/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.util.logging;

import java.util.logging.Level;
import net.maritimecloud.internal.util.logging.Logger;

public abstract class AbstractLogger
implements Logger {
    @Override
    public void debug(String message) {
        this.log(Logger.Level.Debug, message);
    }

    @Override
    public void debug(String message, Throwable cause) {
        this.log(Logger.Level.Debug, message, cause);
    }

    @Override
    public void error(String message) {
        this.log(Logger.Level.Error, message);
    }

    @Override
    public void error(String message, Throwable cause) {
        this.log(Logger.Level.Error, message, cause);
    }

    @Override
    public void fatal(String message) {
        this.log(Logger.Level.Fatal, message);
    }

    @Override
    public void fatal(String message, Throwable cause) {
        this.log(Logger.Level.Fatal, message, cause);
    }

    @Override
    public void info(String message) {
        this.log(Logger.Level.Info, message);
    }

    @Override
    public void info(String message, Throwable cause) {
        this.log(Logger.Level.Info, message, cause);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(Logger.Level.Debug);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(Logger.Level.Error);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(Logger.Level.Fatal);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(Logger.Level.Info);
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(Logger.Level.Trace);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isEnabled(Logger.Level.Warn);
    }

    @Override
    public void log(Logger.Level l, String message) {
        this.log(l, message, null);
    }

    @Override
    public void trace(String message) {
        this.log(Logger.Level.Trace, message);
    }

    @Override
    public void trace(String message, Throwable cause) {
        this.log(Logger.Level.Trace, message, cause);
    }

    @Override
    public void warn(String message) {
        this.log(Logger.Level.Warn, message);
    }

    @Override
    public void warn(String message, Throwable cause) {
        this.log(Logger.Level.Warn, message, cause);
    }

    protected static Level toJdkLevel(Logger.Level level) {
        switch (level) {
            case Trace: {
                return Level.FINEST;
            }
            case Debug: {
                return Level.FINE;
            }
            case Error: {
                return Level.SEVERE;
            }
            case Fatal: {
                return Level.SEVERE;
            }
            case Info: {
                return Level.INFO;
            }
        }
        return Level.WARNING;
    }
}

