/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.util.logging;

import net.maritimecloud.internal.util.logging.LogFactory;

public interface Logger {
    public String getName();

    public void debug(String var1);

    public void debug(String var1, Throwable var2);

    public void error(String var1);

    public void error(String var1, Throwable var2);

    public void fatal(String var1);

    public void fatal(String var1, Throwable var2);

    public void info(String var1);

    public void info(String var1, Throwable var2);

    public boolean isDebugEnabled();

    public boolean isEnabled(Level var1);

    public boolean isErrorEnabled();

    public boolean isFatalEnabled();

    public boolean isInfoEnabled();

    public boolean isTraceEnabled();

    public boolean isWarnEnabled();

    public void log(Level var1, String var2);

    public void log(Level var1, String var2, Throwable var3);

    public void trace(String var1);

    public void trace(String var1, Throwable var2);

    public void warn(String var1);

    public void warn(String var1, Throwable var2);

    public static Logger get(Class<?> cl) {
        return LogFactory.LOG_FACTORY.apply(cl);
    }

    public static enum Level {
        Debug(1),
        Error(4),
        Fatal(5),
        Info(2),
        Off(Integer.MAX_VALUE),
        Trace(0),
        Warn(3);

        private final int level;

        private Level(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

