/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.internal.util.logging;

import java.util.Objects;
import net.maritimecloud.internal.util.logging.AbstractLogger;
import net.maritimecloud.internal.util.logging.Logger;
import org.slf4j.Logger;

final class SLF4JLogger
extends AbstractLogger {
    final Logger logger;

    SLF4JLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger is null");
    }

    public boolean equals(Object obj) {
        return obj instanceof SLF4JLogger && ((SLF4JLogger)obj).logger.equals(this.logger);
    }

    @Override
    public String getName() {
        return this.logger.getName();
    }

    public int hashCode() {
        return this.logger.hashCode();
    }

    @Override
    public boolean isEnabled(Logger.Level level) {
        switch (level) {
            case Trace: {
                return this.logger.isTraceEnabled();
            }
            case Debug: {
                return this.logger.isDebugEnabled();
            }
            case Error: {
                return this.logger.isErrorEnabled();
            }
            case Fatal: {
                return this.logger.isErrorEnabled();
            }
            case Info: {
                return this.logger.isInfoEnabled();
            }
        }
        return this.logger.isWarnEnabled();
    }

    @Override
    public void log(Logger.Level level, String message) {
        switch (level) {
            case Trace: {
                this.logger.trace(message);
                break;
            }
            case Debug: {
                this.logger.debug(message);
                break;
            }
            case Error: {
                this.logger.error(message);
                break;
            }
            case Fatal: {
                this.logger.error(message);
                break;
            }
            case Info: {
                this.logger.info(message);
                break;
            }
            default: {
                this.logger.warn(message);
            }
        }
    }

    @Override
    public void log(Logger.Level level, String message, Throwable cause) {
        switch (level) {
            case Trace: {
                this.logger.trace(message, cause);
                break;
            }
            case Debug: {
                this.logger.debug(message, cause);
                break;
            }
            case Error: {
                this.logger.error(message, cause);
                break;
            }
            case Fatal: {
                this.logger.error(message, cause);
                break;
            }
            case Info: {
                this.logger.info(message, cause);
                break;
            }
            default: {
                this.logger.warn(message, cause);
            }
        }
    }
}

