/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.message;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Objects;
import net.maritimecloud.internal.message.text.json.JsonMessageReader;
import net.maritimecloud.internal.message.text.json.JsonValueWriter;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.message.ValueReader;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.message.ValueWriter;

public abstract class MessageSerializer<T extends Message>
extends ValueSerializer<T> {
    public abstract T read(MessageReader var1) throws IOException;

    @Override
    public final T read(ValueReader reader) throws IOException {
        return reader.readMessage(this);
    }

    public abstract void write(T var1, MessageWriter var2) throws IOException;

    @Override
    public final void write(T value, ValueWriter writer) throws IOException {
        writer.writeMessage(value, this);
    }

    public static <T extends Message> String writeToJSON(T message, MessageSerializer<T> serializer) {
        StringWriter sw = new StringWriter();
        try {
            MessageSerializer.writeToJSON(message, serializer, sw);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write message as JSON", e);
        }
        return sw.toString();
    }

    @Override
    public void write(int tag, String name, T t, MessageWriter writer) throws IOException {
        writer.writeMessage(tag, name, t, this);
    }

    public static <T extends Message> void writeToJSON(T message, MessageSerializer<T> serializer, Writer w) throws IOException {
        Objects.requireNonNull(serializer);
        new JsonValueWriter(w).writeMessage(message, serializer);
        w.flush();
    }

    public static <T extends Message> T readFromJSON(MessageSerializer<T> parser, CharSequence cs) {
        JsonMessageReader r = new JsonMessageReader(cs);
        try {
            return parser.read(r);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read message from JSON", e);
        }
    }
}

