/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.message;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public interface MessageWriter
extends Closeable,
Flushable {
    public MessageFormatType getFormatType();

    default public void writeBinary(int tag, String name, byte[] bytes) throws IOException {
        this.writeBinary(tag, name, bytes, 0, bytes.length);
    }

    default public void writeBinary(int tag, String name, byte[] bytes, int offset, int length) throws IOException {
        this.writeBinary(tag, name, Binary.copyFrom(bytes, offset, length));
    }

    default public void writeBinary(int tag, String name, ByteBuffer buffer) throws IOException {
        this.writeBinary(tag, name, Binary.copyFrom(buffer));
    }

    public void writeBinary(int var1, String var2, Binary var3) throws IOException;

    public void writeBoolean(int var1, String var2, Boolean var3) throws IOException;

    public void writeDouble(int var1, String var2, Double var3) throws IOException;

    public void writeEnum(int var1, String var2, MessageEnum var3) throws IOException;

    public void writeFloat(int var1, String var2, Float var3) throws IOException;

    public void writeInt(int var1, String var2, Integer var3) throws IOException;

    public void writeVarInt(int var1, String var2, BigInteger var3) throws IOException;

    public void writeDecimal(int var1, String var2, BigDecimal var3) throws IOException;

    public void writePosition(int var1, String var2, Position var3) throws IOException;

    public void writePositionTime(int var1, String var2, PositionTime var3) throws IOException;

    public void writeTimestamp(int var1, String var2, Timestamp var3) throws IOException;

    public void writeInt64(int var1, String var2, Long var3) throws IOException;

    public <T> void writeList(int var1, String var2, List<T> var3, ValueSerializer<T> var4) throws IOException;

    public <K, V> void writeMap(int var1, String var2, Map<K, V> var3, ValueSerializer<K> var4, ValueSerializer<V> var5) throws IOException;

    public <T extends Message> void writeMessage(int var1, String var2, T var3, MessageSerializer<T> var4) throws IOException;

    public <T> void writeSet(int var1, String var2, Set<T> var3, ValueSerializer<T> var4) throws IOException;

    public void writeText(int var1, String var2, String var3) throws IOException;
}

