/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.message;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.maritimecloud.message.Message;
import net.maritimecloud.message.MessageEnum;
import net.maritimecloud.message.MessageEnumSerializer;
import net.maritimecloud.message.MessageFormatType;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.SerializationException;
import net.maritimecloud.message.ValueSerializer;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public interface ValueReader {
    public MessageFormatType getFormatType();

    public Integer readInt() throws IOException;

    public Long readInt64() throws IOException;

    public BigInteger readVarInt() throws IOException;

    public Float readFloat() throws IOException;

    public Double readDouble() throws IOException;

    public BigDecimal readDecimal() throws IOException;

    public Boolean readBoolean() throws IOException;

    public Binary readBinary() throws IOException;

    public String readText() throws IOException;

    default public Timestamp readTimestamp() throws IOException {
        long timestamp = this.readInt64();
        if (timestamp < 0L) {
            throw new SerializationException("Read a negative timestamp, must be positive, was " + timestamp);
        }
        return Timestamp.create(timestamp);
    }

    public Position readPosition() throws IOException;

    public PositionTime readPositionTime() throws IOException;

    public <T extends MessageEnum> T readEnum(MessageEnumSerializer<T> var1) throws IOException;

    public <T extends Message> T readMessage(MessageSerializer<T> var1) throws IOException;

    public <T> List<T> readList(ValueSerializer<T> var1) throws IOException;

    default public <T> Set<T> readSet(ValueSerializer<T> parser) throws IOException {
        return new LinkedHashSet<T>(this.readList(parser));
    }

    public <K, V> Map<K, V> readMap(ValueSerializer<K> var1, ValueSerializer<V> var2) throws IOException;
}

