/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.message;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.message.ValueReader;
import net.maritimecloud.message.ValueWriter;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public abstract class ValueSerializer<T> {
    public static final ValueSerializer<Binary> BINARY = new ValueSerializer<Binary>(){

        @Override
        public Binary read(ValueReader reader) throws IOException {
            return reader.readBinary();
        }

        @Override
        public void write(Binary t, ValueWriter writer) throws IOException {
            writer.writeBinary(t);
        }

        @Override
        public void write(int tag, String name, Binary t, MessageWriter writer) throws IOException {
            writer.writeBinary(tag, name, t);
        }
    };
    public static final ValueSerializer<Boolean> BOOLEAN = new ValueSerializer<Boolean>(){

        @Override
        public Boolean read(ValueReader reader) throws IOException {
            return reader.readBoolean();
        }

        @Override
        public void write(Boolean t, ValueWriter writer) throws IOException {
            writer.writeBoolean(t);
        }

        @Override
        public void write(int tag, String name, Boolean t, MessageWriter writer) throws IOException {
            writer.writeBoolean(tag, name, t);
        }
    };
    public static final ValueSerializer<BigDecimal> DECIMAL = new ValueSerializer<BigDecimal>(){

        @Override
        public BigDecimal read(ValueReader reader) throws IOException {
            return reader.readDecimal();
        }

        @Override
        public void write(BigDecimal t, ValueWriter writer) throws IOException {
            writer.writeDecimal(t);
        }

        @Override
        public void write(int tag, String name, BigDecimal t, MessageWriter writer) throws IOException {
            writer.writeDecimal(tag, name, t);
        }
    };
    public static final ValueSerializer<Double> DOUBLE = new ValueSerializer<Double>(){

        @Override
        public Double read(ValueReader reader) throws IOException {
            return reader.readDouble();
        }

        @Override
        public void write(Double t, ValueWriter writer) throws IOException {
            writer.writeDouble(t);
        }

        @Override
        public void write(int tag, String name, Double t, MessageWriter writer) throws IOException {
            writer.writeDouble(tag, name, t);
        }
    };
    public static final ValueSerializer<Float> FLOAT = new ValueSerializer<Float>(){

        @Override
        public Float read(ValueReader reader) throws IOException {
            return reader.readFloat();
        }

        @Override
        public void write(Float t, ValueWriter writer) throws IOException {
            writer.writeFloat(t);
        }

        @Override
        public void write(int tag, String name, Float t, MessageWriter writer) throws IOException {
            writer.writeFloat(tag, name, t);
        }
    };
    public static final ValueSerializer<Integer> INT = new ValueSerializer<Integer>(){

        @Override
        public Integer read(ValueReader reader) throws IOException {
            return reader.readInt();
        }

        @Override
        public void write(Integer t, ValueWriter writer) throws IOException {
            writer.writeInt(t);
        }

        @Override
        public void write(int tag, String name, Integer t, MessageWriter writer) throws IOException {
            writer.writeInt(tag, name, t);
        }
    };
    public static final ValueSerializer<Long> INT64 = new ValueSerializer<Long>(){

        @Override
        public Long read(ValueReader reader) throws IOException {
            return reader.readInt64();
        }

        @Override
        public void write(Long t, ValueWriter writer) throws IOException {
            writer.writeInt64(t);
        }

        @Override
        public void write(int tag, String name, Long t, MessageWriter writer) throws IOException {
            writer.writeInt64(tag, name, t);
        }
    };
    public static final ValueSerializer<Position> POSITION = new ValueSerializer<Position>(){

        @Override
        public Position read(ValueReader reader) throws IOException {
            return reader.readPosition();
        }

        @Override
        public void write(Position t, ValueWriter writer) throws IOException {
            writer.writePosition(t);
        }

        @Override
        public void write(int tag, String name, Position t, MessageWriter writer) throws IOException {
            writer.writePosition(tag, name, t);
        }
    };
    public static final ValueSerializer<PositionTime> POSITION_TIME = new ValueSerializer<PositionTime>(){

        @Override
        public PositionTime read(ValueReader reader) throws IOException {
            return reader.readPositionTime();
        }

        @Override
        public void write(PositionTime t, ValueWriter writer) throws IOException {
            writer.writePositionTime(t);
        }

        @Override
        public void write(int tag, String name, PositionTime t, MessageWriter writer) throws IOException {
            writer.writePositionTime(tag, name, t);
        }
    };
    public static final ValueSerializer<String> TEXT = new ValueSerializer<String>(){

        @Override
        public String read(ValueReader reader) throws IOException {
            return reader.readText();
        }

        @Override
        public void write(String t, ValueWriter writer) throws IOException {
            writer.writeText(t);
        }

        @Override
        public void write(int tag, String name, String t, MessageWriter writer) throws IOException {
            writer.writeText(tag, name, t);
        }
    };
    public static final ValueSerializer<Timestamp> TIMESTAMP = new ValueSerializer<Timestamp>(){

        @Override
        public Timestamp read(ValueReader reader) throws IOException {
            return reader.readTimestamp();
        }

        @Override
        public void write(Timestamp t, ValueWriter writer) throws IOException {
            writer.writeTimestamp(t);
        }

        @Override
        public void write(int tag, String name, Timestamp t, MessageWriter writer) throws IOException {
            writer.writeTimestamp(tag, name, t);
        }
    };
    public static final ValueSerializer<BigInteger> VARINT = new ValueSerializer<BigInteger>(){

        @Override
        public BigInteger read(ValueReader reader) throws IOException {
            return reader.readVarInt();
        }

        @Override
        public void write(BigInteger t, ValueWriter writer) throws IOException {
            writer.writeVarInt(t);
        }

        @Override
        public void write(int tag, String name, BigInteger t, MessageWriter writer) throws IOException {
            writer.writeVarInt(tag, name, t);
        }
    };

    public final ValueSerializer<List<T>> listOf() {
        return new ListSerializer(this);
    }

    public final <V> ValueSerializer<Map<T, V>> mappingTo(ValueSerializer<V> valueParser) {
        return new MapSerializer(this, valueParser);
    }

    public abstract T read(ValueReader var1) throws IOException;

    public final ValueSerializer<Set<T>> setOf() {
        return new SetSerializer(this);
    }

    public abstract void write(T var1, ValueWriter var2) throws IOException;

    public abstract void write(int var1, String var2, T var3, MessageWriter var4) throws IOException;

    static class SetSerializer<E>
    extends ValueSerializer<Set<E>> {
        final ValueSerializer<E> serializer;

        SetSerializer(ValueSerializer<E> serializer) {
            this.serializer = Objects.requireNonNull(serializer);
        }

        @Override
        public Set<E> read(ValueReader reader) throws IOException {
            return reader.readSet(this.serializer);
        }

        @Override
        public void write(Set<E> t, ValueWriter writer) throws IOException {
            writer.writeSet(t, this.serializer);
        }

        @Override
        public void write(int tag, String name, Set<E> t, MessageWriter writer) throws IOException {
            writer.writeSet(tag, name, t, this.serializer);
        }
    }

    static class MapSerializer<K, V>
    extends ValueSerializer<Map<K, V>> {
        final ValueSerializer<K> keyParser;
        final ValueSerializer<V> valueParser;

        MapSerializer(ValueSerializer<K> keyParser, ValueSerializer<V> valueParser) {
            this.keyParser = Objects.requireNonNull(keyParser);
            this.valueParser = Objects.requireNonNull(valueParser);
        }

        @Override
        public Map<K, V> read(ValueReader reader) throws IOException {
            return reader.readMap(this.keyParser, this.valueParser);
        }

        @Override
        public void write(Map<K, V> t, ValueWriter writer) throws IOException {
            writer.writeMap(t, this.keyParser, this.valueParser);
        }

        @Override
        public void write(int tag, String name, Map<K, V> t, MessageWriter writer) throws IOException {
            writer.writeMap(tag, name, t, this.keyParser, this.valueParser);
        }
    }

    static class ListSerializer<E>
    extends ValueSerializer<List<E>> {
        final ValueSerializer<E> serializer;

        ListSerializer(ValueSerializer<E> serializer) {
            this.serializer = Objects.requireNonNull(serializer);
        }

        @Override
        public List<E> read(ValueReader reader) throws IOException {
            return reader.readList(this.serializer);
        }

        @Override
        public void write(List<E> t, ValueWriter writer) throws IOException {
            writer.writeList(t, this.serializer);
        }

        @Override
        public void write(int tag, String name, List<E> t, MessageWriter writer) throws IOException {
            writer.writeList(tag, name, t, this.serializer);
        }
    }
}

