/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util;

import java.util.NoSuchElementException;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.LiteralBinary;

class BoundedBinary
extends LiteralBinary {
    private final int bytesOffset;
    private final int bytesLength;

    BoundedBinary(byte[] bytes, int offset, int length) {
        super(bytes);
        if (offset < 0) {
            throw new IllegalArgumentException("Offset too small: " + offset);
        }
        if (length < 0) {
            throw new IllegalArgumentException("Length too small: " + offset);
        }
        if ((long)offset + (long)length > (long)bytes.length) {
            throw new IllegalArgumentException("Offset+Length too large: " + offset + "+" + length);
        }
        this.bytesOffset = offset;
        this.bytesLength = length;
    }

    @Override
    public byte byteAt(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index too small: " + index);
        }
        if (index >= this.size()) {
            throw new ArrayIndexOutOfBoundsException("Index too large: " + index + ", " + this.size());
        }
        return this.bytes[this.bytesOffset + index];
    }

    @Override
    public int size() {
        return this.bytesLength;
    }

    @Override
    protected int getOffsetIntoBytes() {
        return this.bytesOffset;
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        System.arraycopy(this.bytes, this.getOffsetIntoBytes() + sourceOffset, target, targetOffset, numberToCopy);
    }

    @Override
    public Binary.ByteIterator iterator() {
        return new BoundedByteIterator();
    }

    class BoundedByteIterator
    implements Binary.ByteIterator {
        private int position;
        private final int limit;

        BoundedByteIterator() {
            this.position = BoundedBinary.this.getOffsetIntoBytes();
            this.limit = this.position + BoundedBinary.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.limit;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            if (this.position >= this.limit) {
                throw new NoSuchElementException();
            }
            return BoundedBinary.this.bytes[this.position++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

