/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.LiteralBinary;

class RopeBinary
extends Binary {
    static final int[] MIN_LENGTH_BY_DEPTH;
    private final int totalLength;
    final Binary left;
    final Binary right;
    private final int leftLength;
    private final int treeDepth;
    private int hash;

    RopeBinary(Binary left, Binary right) {
        this.left = left;
        this.right = right;
        this.leftLength = left.size();
        this.totalLength = this.leftLength + right.size();
        this.treeDepth = Math.max(left.getTreeDepth(), right.getTreeDepth()) + 1;
    }

    static Binary concatenate(Binary left, Binary right) {
        Binary result;
        RopeBinary leftRope;
        RopeBinary ropeBinary = leftRope = left instanceof RopeBinary ? (RopeBinary)left : null;
        if (right.size() == 0) {
            result = left;
        } else if (left.size() == 0) {
            result = right;
        } else {
            int newLength = left.size() + right.size();
            if (newLength < 128) {
                result = RopeBinary.concatenateBytes(left, right);
            } else if (leftRope != null && leftRope.right.size() + right.size() < 128) {
                LiteralBinary newRight = RopeBinary.concatenateBytes(leftRope.right, right);
                result = new RopeBinary(leftRope.left, newRight);
            } else if (leftRope != null && leftRope.left.getTreeDepth() > leftRope.right.getTreeDepth() && leftRope.getTreeDepth() > right.getTreeDepth()) {
                RopeBinary newRight = new RopeBinary(leftRope.right, right);
                result = new RopeBinary(leftRope.left, newRight);
            } else {
                int newDepth = Math.max(left.getTreeDepth(), right.getTreeDepth()) + 1;
                result = newLength >= MIN_LENGTH_BY_DEPTH[newDepth] ? new RopeBinary(left, right) : new Balancer().balance(left, right);
            }
        }
        return result;
    }

    private static LiteralBinary concatenateBytes(Binary left, Binary right) {
        int leftSize = left.size();
        int rightSize = right.size();
        byte[] bytes = new byte[leftSize + rightSize];
        left.copyTo(bytes, 0, 0, leftSize);
        right.copyTo(bytes, 0, leftSize, rightSize);
        return new LiteralBinary(bytes);
    }

    static RopeBinary newInstanceForTest(Binary left, Binary right) {
        return new RopeBinary(left, right);
    }

    @Override
    public byte byteAt(int index) {
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException("Index < 0: " + index);
        }
        if (index > this.totalLength) {
            throw new ArrayIndexOutOfBoundsException("Index > length: " + index + ", " + this.totalLength);
        }
        byte result = index < this.leftLength ? this.left.byteAt(index) : this.right.byteAt(index - this.leftLength);
        return result;
    }

    @Override
    public int size() {
        return this.totalLength;
    }

    @Override
    protected int getTreeDepth() {
        return this.treeDepth;
    }

    @Override
    protected boolean isBalanced() {
        return this.totalLength >= MIN_LENGTH_BY_DEPTH[this.treeDepth];
    }

    @Override
    public Binary substring(int beginIndex, int endIndex) {
        Binary result;
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Beginning index: " + beginIndex + " < 0");
        }
        if (endIndex > this.totalLength) {
            throw new IndexOutOfBoundsException("End index: " + endIndex + " > " + this.totalLength);
        }
        int substringLength = endIndex - beginIndex;
        if (substringLength < 0) {
            throw new IndexOutOfBoundsException("Beginning index larger than ending index: " + beginIndex + ", " + endIndex);
        }
        if (substringLength == 0) {
            result = Binary.EMPTY;
        } else if (substringLength == this.totalLength) {
            result = this;
        } else if (endIndex <= this.leftLength) {
            result = this.left.substring(beginIndex, endIndex);
        } else if (beginIndex >= this.leftLength) {
            result = this.right.substring(beginIndex - this.leftLength, endIndex - this.leftLength);
        } else {
            Binary leftSub = this.left.substring(beginIndex);
            Binary rightSub = this.right.substring(0, endIndex - this.leftLength);
            result = new RopeBinary(leftSub, rightSub);
        }
        return result;
    }

    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        if (sourceOffset + numberToCopy <= this.leftLength) {
            this.left.copyToInternal(target, sourceOffset, targetOffset, numberToCopy);
        } else if (sourceOffset >= this.leftLength) {
            this.right.copyToInternal(target, sourceOffset - this.leftLength, targetOffset, numberToCopy);
        } else {
            int leftLength = this.leftLength - sourceOffset;
            this.left.copyToInternal(target, sourceOffset, targetOffset, leftLength);
            this.right.copyToInternal(target, 0, targetOffset + leftLength, numberToCopy - leftLength);
        }
    }

    @Override
    public void copyTo(ByteBuffer target) {
        this.left.copyTo(target);
        this.right.copyTo(target);
    }

    @Override
    public ByteBuffer asReadOnlyByteBuffer() {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.toByteArray());
        return byteBuffer.asReadOnlyBuffer();
    }

    @Override
    public List<ByteBuffer> asReadOnlyByteBufferList() {
        ArrayList<ByteBuffer> result = new ArrayList<ByteBuffer>();
        PieceIterator pieces = new PieceIterator(this);
        while (pieces.hasNext()) {
            LiteralBinary byteString = pieces.next();
            result.add(byteString.asReadOnlyByteBuffer());
        }
        return result;
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        this.left.writeTo(outputStream);
        this.right.writeTo(outputStream);
    }

    @Override
    public String toString(String charsetName) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), charsetName);
    }

    @Override
    public boolean isValidUtf8() {
        int leftPartial = this.left.partialIsValidUtf8(0, 0, this.leftLength);
        int state = this.right.partialIsValidUtf8(leftPartial, 0, this.right.size());
        return state == 0;
    }

    @Override
    protected int partialIsValidUtf8(int state, int offset, int length) {
        int toIndex = offset + length;
        if (toIndex <= this.leftLength) {
            return this.left.partialIsValidUtf8(state, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialIsValidUtf8(state, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialIsValidUtf8(state, offset, leftLength);
        return this.right.partialIsValidUtf8(leftPartial, 0, length - leftLength);
    }

    @Override
    public boolean equals(Object other) {
        int cachedOtherHash;
        if (other == this) {
            return true;
        }
        if (!(other instanceof Binary)) {
            return false;
        }
        Binary otherBinary = (Binary)other;
        if (this.totalLength != otherBinary.size()) {
            return false;
        }
        if (this.totalLength == 0) {
            return true;
        }
        if (this.hash != 0 && (cachedOtherHash = otherBinary.peekCachedHashCode()) != 0 && this.hash != cachedOtherHash) {
            return false;
        }
        return this.equalsFragments(otherBinary);
    }

    private boolean equalsFragments(Binary other) {
        int thisOffset = 0;
        PieceIterator thisIter = new PieceIterator(this);
        LiteralBinary thisString = (LiteralBinary)thisIter.next();
        int thatOffset = 0;
        PieceIterator thatIter = new PieceIterator(other);
        LiteralBinary thatString = (LiteralBinary)thatIter.next();
        int pos = 0;
        while (true) {
            boolean stillEqual;
            int thisRemaining = thisString.size() - thisOffset;
            int thatRemaining = thatString.size() - thatOffset;
            int bytesToCompare = Math.min(thisRemaining, thatRemaining);
            boolean bl = stillEqual = thisOffset == 0 ? thisString.equalsRange(thatString, thatOffset, bytesToCompare) : thatString.equalsRange(thisString, thisOffset, bytesToCompare);
            if (!stillEqual) {
                return false;
            }
            if ((pos += bytesToCompare) >= this.totalLength) {
                if (pos == this.totalLength) {
                    return true;
                }
                throw new IllegalStateException();
            }
            if (bytesToCompare == thisRemaining) {
                thisOffset = 0;
                thisString = (LiteralBinary)thisIter.next();
            } else {
                thisOffset += bytesToCompare;
            }
            if (bytesToCompare == thatRemaining) {
                thatOffset = 0;
                thatString = (LiteralBinary)thatIter.next();
                continue;
            }
            thatOffset += bytesToCompare;
        }
    }

    @Override
    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.totalLength;
            if ((h = this.partialHash(h, 0, this.totalLength)) == 0) {
                h = 1;
            }
            this.hash = h;
        }
        return h;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    @Override
    protected int partialHash(int h, int offset, int length) {
        int toIndex = offset + length;
        if (toIndex <= this.leftLength) {
            return this.left.partialHash(h, offset, length);
        }
        if (offset >= this.leftLength) {
            return this.right.partialHash(h, offset - this.leftLength, length);
        }
        int leftLength = this.leftLength - offset;
        int leftPartial = this.left.partialHash(h, offset, leftLength);
        return this.right.partialHash(leftPartial, 0, length - leftLength);
    }

    @Override
    public InputStream newInput() {
        return new RopeInputStream();
    }

    @Override
    public Binary.ByteIterator iterator() {
        return new RopeByteIterator();
    }

    static {
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        int f1 = 1;
        int f2 = 1;
        while (f2 > 0) {
            numbers.add(f2);
            int temp = f1 + f2;
            f1 = f2;
            f2 = temp;
        }
        numbers.add(Integer.MAX_VALUE);
        MIN_LENGTH_BY_DEPTH = new int[numbers.size()];
        for (int i = 0; i < MIN_LENGTH_BY_DEPTH.length; ++i) {
            RopeBinary.MIN_LENGTH_BY_DEPTH[i] = (Integer)numbers.get(i);
        }
    }

    private class RopeInputStream
    extends InputStream {
        private PieceIterator pieceIterator;
        private LiteralBinary currentPiece;
        private int currentPieceSize;
        private int currentPieceIndex;
        private int currentPieceOffsetInRope;
        private int mark;

        public RopeInputStream() {
            this.initialize();
        }

        @Override
        public int read(byte[] b, int offset, int length) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (offset < 0 || length < 0 || length > b.length - offset) {
                throw new IndexOutOfBoundsException();
            }
            return this.readSkipInternal(b, offset, length);
        }

        @Override
        public long skip(long length) {
            if (length < 0L) {
                throw new IndexOutOfBoundsException();
            }
            if (length > Integer.MAX_VALUE) {
                length = Integer.MAX_VALUE;
            }
            return this.readSkipInternal(null, 0, (int)length);
        }

        private int readSkipInternal(byte[] b, int offset, int length) {
            int bytesRemaining;
            int count;
            for (bytesRemaining = length; bytesRemaining > 0; bytesRemaining -= count) {
                this.advanceIfCurrentPieceFullyRead();
                if (this.currentPiece == null) {
                    if (bytesRemaining != length) break;
                    return -1;
                }
                int currentPieceRemaining = this.currentPieceSize - this.currentPieceIndex;
                count = Math.min(currentPieceRemaining, bytesRemaining);
                if (b != null) {
                    this.currentPiece.copyTo(b, this.currentPieceIndex, offset, count);
                    offset += count;
                }
                this.currentPieceIndex += count;
            }
            return length - bytesRemaining;
        }

        @Override
        public int read() throws IOException {
            this.advanceIfCurrentPieceFullyRead();
            if (this.currentPiece == null) {
                return -1;
            }
            return this.currentPiece.byteAt(this.currentPieceIndex++) & 0xFF;
        }

        @Override
        public int available() throws IOException {
            int bytesRead = this.currentPieceOffsetInRope + this.currentPieceIndex;
            return RopeBinary.this.size() - bytesRead;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void mark(int readAheadLimit) {
            this.mark = this.currentPieceOffsetInRope + this.currentPieceIndex;
        }

        @Override
        public synchronized void reset() {
            this.initialize();
            this.readSkipInternal(null, 0, this.mark);
        }

        private void initialize() {
            this.pieceIterator = new PieceIterator(RopeBinary.this);
            this.currentPiece = this.pieceIterator.next();
            this.currentPieceSize = this.currentPiece.size();
            this.currentPieceIndex = 0;
            this.currentPieceOffsetInRope = 0;
        }

        private void advanceIfCurrentPieceFullyRead() {
            if (this.currentPiece != null && this.currentPieceIndex == this.currentPieceSize) {
                this.currentPieceOffsetInRope += this.currentPieceSize;
                this.currentPieceIndex = 0;
                if (this.pieceIterator.hasNext()) {
                    this.currentPiece = this.pieceIterator.next();
                    this.currentPieceSize = this.currentPiece.size();
                } else {
                    this.currentPiece = null;
                    this.currentPieceSize = 0;
                }
            }
        }
    }

    class RopeByteIterator
    implements Binary.ByteIterator {
        private final PieceIterator pieces;
        private Binary.ByteIterator bytes;
        int bytesRemaining;

        RopeByteIterator() {
            this.pieces = new PieceIterator(RopeBinary.this);
            this.bytes = this.pieces.next().iterator();
            this.bytesRemaining = RopeBinary.this.size();
        }

        @Override
        public boolean hasNext() {
            return this.bytesRemaining > 0;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        @Override
        public byte nextByte() {
            if (!this.bytes.hasNext()) {
                this.bytes = this.pieces.next().iterator();
            }
            --this.bytesRemaining;
            return this.bytes.nextByte();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class PieceIterator
    implements Iterator<LiteralBinary> {
        private final Stack<RopeBinary> breadCrumbs = new Stack();
        private LiteralBinary next;

        PieceIterator(Binary root) {
            this.next = this.getLeafByLeft(root);
        }

        private LiteralBinary getLeafByLeft(Binary root) {
            Binary pos = root;
            while (pos instanceof RopeBinary) {
                RopeBinary rbs = (RopeBinary)pos;
                this.breadCrumbs.push(rbs);
                pos = rbs.left;
            }
            return (LiteralBinary)pos;
        }

        private LiteralBinary getNextNonEmptyLeaf() {
            LiteralBinary result;
            do {
                if (!this.breadCrumbs.isEmpty()) continue;
                return null;
            } while ((result = this.getLeafByLeft(this.breadCrumbs.pop().right)).isEmpty());
            return result;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public LiteralBinary next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            LiteralBinary result = this.next;
            this.next = this.getNextNonEmptyLeaf();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class Balancer {
        private final Stack<Binary> prefixesStack = new Stack();

        Balancer() {
        }

        Binary balance(Binary left, Binary right) {
            this.doBalance(left);
            this.doBalance(right);
            Binary partialString = this.prefixesStack.pop();
            while (!this.prefixesStack.isEmpty()) {
                Binary newLeft = this.prefixesStack.pop();
                partialString = new RopeBinary(newLeft, partialString);
            }
            return partialString;
        }

        private void doBalance(Binary root) {
            if (root.isBalanced()) {
                this.insert(root);
            } else if (root instanceof RopeBinary) {
                RopeBinary rbs = (RopeBinary)root;
                this.doBalance(rbs.left);
                this.doBalance(rbs.right);
            } else {
                throw new IllegalArgumentException("Has a new type of Binary been created? Found " + root.getClass());
            }
        }

        private void insert(Binary byteString) {
            int depthBin = this.getDepthBinForLength(byteString.size());
            int binEnd = MIN_LENGTH_BY_DEPTH[depthBin + 1];
            if (this.prefixesStack.isEmpty() || this.prefixesStack.peek().size() >= binEnd) {
                this.prefixesStack.push(byteString);
            } else {
                Binary left;
                int binStart = MIN_LENGTH_BY_DEPTH[depthBin];
                Binary newTree = this.prefixesStack.pop();
                while (!this.prefixesStack.isEmpty() && this.prefixesStack.peek().size() < binStart) {
                    left = this.prefixesStack.pop();
                    newTree = new RopeBinary(left, newTree);
                }
                newTree = new RopeBinary(newTree, byteString);
                while (!this.prefixesStack.isEmpty()) {
                    depthBin = this.getDepthBinForLength(newTree.size());
                    binEnd = MIN_LENGTH_BY_DEPTH[depthBin + 1];
                    if (this.prefixesStack.peek().size() >= binEnd) break;
                    left = this.prefixesStack.pop();
                    newTree = new RopeBinary(left, newTree);
                }
                this.prefixesStack.push(newTree);
            }
        }

        private int getDepthBinForLength(int length) {
            int depth = Arrays.binarySearch(MIN_LENGTH_BY_DEPTH, length);
            if (depth < 0) {
                int insertionPoint = -(depth + 1);
                depth = insertionPoint - 1;
            }
            return depth;
        }
    }
}

