/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.util.geometry.Area;
import net.maritimecloud.util.geometry.CoordinateSystem;
import net.maritimecloud.util.geometry.Line;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.Rectangle;

public class Circle
extends Area {
    public static final MessageSerializer<Circle> SERIALIZER = new MessageSerializer<Circle>(){
        private static final String NAME_CENTER_LATITIUDE = "center-latitude";
        private static final String NAME_CENTER_LONGITUDE = "center-longitude";
        private static final String NAME_RADIUS = "radius";

        @Override
        public Circle read(MessageReader reader) throws IOException {
            double lat = reader.readDouble(1, NAME_CENTER_LATITIUDE);
            double lon = reader.readDouble(2, NAME_CENTER_LONGITUDE);
            double radius = reader.readDouble(3, NAME_RADIUS);
            return new Circle(Position.create(lat, lon), radius);
        }

        @Override
        public void write(Circle message, MessageWriter w) throws IOException {
            w.writeDouble(1, NAME_CENTER_LATITIUDE, message.center.latitude);
            w.writeDouble(2, NAME_CENTER_LONGITUDE, message.center.longitude);
            w.writeDouble(3, NAME_RADIUS, message.radius);
        }
    };
    private static final long serialVersionUID = 1L;
    final Position center;
    final double radius;

    Circle(Position center, double radius) {
        this.center = Objects.requireNonNull(center, "center is null");
        if (radius <= 0.0) {
            throw new IllegalArgumentException("Radius must be positive, was " + radius);
        }
        this.radius = radius;
    }

    public boolean contains(Circle c) {
        return this.center.rhumbLineDistanceTo(c.center) <= this.radius + c.radius;
    }

    @Override
    public boolean contains(Position position) {
        return this.center.rhumbLineDistanceTo(position) <= this.radius;
    }

    public boolean equals(Circle other) {
        return other == this || other != null && this.center.equals(other.center) && this.radius == other.radius;
    }

    public boolean equals(Object other) {
        return other instanceof Circle && this.equals((Circle)other);
    }

    public double geodesicDistanceTo(Position other) {
        return Math.max(0.0, this.center.geodesicDistanceTo(other) - this.radius);
    }

    @Override
    public Rectangle getBoundingBox() {
        double top = CoordinateSystem.CARTESIAN.pointOnBearing((Position)this.center, (double)this.radius, (double)0.0).latitude;
        double right = CoordinateSystem.CARTESIAN.pointOnBearing((Position)this.center, (double)this.radius, (double)90.0).longitude;
        double bottom = CoordinateSystem.CARTESIAN.pointOnBearing((Position)this.center, (double)this.radius, (double)180.0).latitude;
        double left = CoordinateSystem.CARTESIAN.pointOnBearing((Position)this.center, (double)this.radius, (double)270.0).longitude;
        Position topLeft = Position.create(top, left);
        Position buttomRight = Position.create(bottom, right);
        return Rectangle.create(topLeft, buttomRight);
    }

    public Position getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    @Override
    public Position getRandomPosition(Random r) {
        Rectangle bb = this.getBoundingBox();
        for (int i = 0; i < 10000; ++i) {
            Position p = bb.getRandomPosition(r);
            if (!this.contains(p)) continue;
            return p;
        }
        throw new RuntimeException("Inifinite loop");
    }

    public int hashCode() {
        return this.center.hashCode() ^ new Double(this.radius).hashCode();
    }

    @Override
    public Circle immutable() {
        return this;
    }

    @Override
    public boolean intersects(Area other) {
        if (other instanceof Circle) {
            return this.intersects((Circle)other);
        }
        if (other instanceof Rectangle) {
            return this.intersects((Rectangle)other);
        }
        throw new UnsupportedOperationException("Only circles and BoundingBoxes supported");
    }

    public boolean intersects(Circle other) {
        double centerDistance = CoordinateSystem.CARTESIAN.distanceBetween(this.center, other.center);
        return this.radius + other.radius >= centerDistance;
    }

    public boolean intersects(Line line) {
        return this.intersects(line.getStart(), line.getEnd());
    }

    boolean intersects(Position p1, Position p2) {
        double c;
        double q;
        double a;
        double caY;
        double baX = p2.getLongitude() - p1.getLongitude();
        double baY = p2.getLatitude() - p1.getLatitude();
        double caX = this.center.getLongitude() - p2.getLongitude();
        double bBy2 = baX * caX + baY * (caY = this.center.getLatitude() - p2.getLatitude());
        double pBy2 = bBy2 / (a = baX * baX + baY * baY);
        double disc = pBy2 * pBy2 - (q = (c = caX * caX + caY * caY - this.radius * this.radius) / a);
        return disc >= 0.0;
    }

    public boolean intersects(Rectangle other) {
        return other.intersects(this);
    }

    public double rhumbLineDistanceTo(Position position) {
        return Math.max(0.0, this.center.rhumbLineDistanceTo(position) - this.radius);
    }

    public String toString() {
        return "Circle: center = " + this.center + ", radius = " + this.radius;
    }

    public Circle withCenter(Position center) {
        return new Circle(center, this.radius);
    }

    public Circle withRadius(double radius) {
        return new Circle(this.center, radius);
    }

    public static Circle create(double latitude, double longitude, double radius) {
        return new Circle(Position.create(latitude, longitude), radius);
    }

    public static Circle create(Position center, double radius) {
        return new Circle(center, radius);
    }

    public static Circle fromJSON(CharSequence string) {
        return MessageSerializer.readFromJSON(SERIALIZER, string);
    }

    public static Circle random() {
        return Circle.random(ThreadLocalRandom.current());
    }

    public static Circle random(Random rnd) {
        return new Circle(Position.random(), (1.0 - rnd.nextDouble()) * 10000.0);
    }
}

