/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import net.maritimecloud.util.geometry.Position;

enum CoordinateSystem {
    CARTESIAN{

        @Override
        double distanceBetween(double latitude1, double longitude1, double latitude2, double longitude2) {
            double q;
            double lat1 = Math.toRadians(latitude1);
            double lat2 = Math.toRadians(latitude2);
            double dLat = Math.toRadians(latitude2 - latitude1);
            double dLon = Math.toRadians(Math.abs(longitude2 - longitude1));
            double dPhi = Math.log(Math.tan(lat2 / 2.0 + 0.7853981633974483) / Math.tan(lat1 / 2.0 + 0.7853981633974483));
            double d = q = dPhi == 0.0 ? Math.cos(lat1) : dLat / dPhi;
            if (dLon > Math.PI) {
                dLon = Math.PI * 2 - dLon;
            }
            return Math.sqrt(dLat * dLat + q * q * dLon * dLon) * 6371.0087714 * 1000.0;
        }

        @Override
        Position pointOnBearing0(double startLatDegrees, double startLonDegrees, double distanceMeters, double bearingDegrees) {
            startLatDegrees = Math.toRadians(startLatDegrees);
            startLonDegrees = Math.toRadians(startLonDegrees);
            bearingDegrees = Math.toRadians(bearingDegrees);
            double earthRadius = 6371008.7714;
            double endLat = Math.asin(Math.sin(startLatDegrees) * Math.cos(distanceMeters / 6371008.7714) + Math.cos(startLatDegrees) * Math.sin(distanceMeters / 6371008.7714) * Math.cos(bearingDegrees));
            double endLon = startLonDegrees + Math.atan2(Math.sin(bearingDegrees) * Math.sin(distanceMeters / 6371008.7714) * Math.cos(startLatDegrees), Math.cos(distanceMeters / 6371008.7714) - Math.sin(startLatDegrees) * Math.sin(endLat));
            return Position.create(Math.toDegrees(endLat), Math.toDegrees(endLon));
        }
    }
    ,
    GEODETIC{

        @Override
        double distanceBetween(double latitude1, double longitude1, double latitude2, double longitude2) {
            return 2.vincentyFormula(latitude1, longitude1, latitude2, longitude2, VincentyCalculationType.DISTANCE);
        }

        @Override
        Position pointOnBearing0(double latitude, double longitude, double distance, double bearing) {
            throw new UnsupportedOperationException();
        }
    };

    public static final double EARTH_EQUATORIAL_RADIUS_KM = 6378.137;
    public static final double EARTH_MEAN_RADIUS_KM = 6371.0087714;

    abstract double distanceBetween(double var1, double var3, double var5, double var7);

    public double distanceBetween(Position p1, Position p2) {
        return this.distanceBetween(p1.getLatitude(), p1.getLongitude(), p2.getLatitude(), p2.getLongitude());
    }

    public Position pointOnBearing(Position position, double distance, double bearing) {
        if (distance < 0.0) {
            throw new IllegalArgumentException("distance must be positive, was " + distance);
        }
        if (distance == 0.0) {
            return position;
        }
        return this.pointOnBearing0(position.getLatitude(), position.getLongitude(), distance, bearing);
    }

    abstract Position pointOnBearing0(double var1, double var3, double var5, double var7);

    static double vincentyFormula(double latitude1, double longitude1, double latitude2, double longitude2, VincentyCalculationType type) {
        double a = 6378137.0;
        double b = 6356752.3142;
        double f = 0.0033528106647474805;
        double L = Math.toRadians(longitude2 - longitude1);
        double U1 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(latitude1)));
        double U2 = Math.atan((1.0 - f) * Math.tan(Math.toRadians(latitude2)));
        double sinU1 = Math.sin(U1);
        double cosU1 = Math.cos(U1);
        double sinU2 = Math.sin(U2);
        double cosU2 = Math.cos(U2);
        double lambda = L;
        double lambdaP = Math.PI * 2;
        double iterLimit = 20.0;
        double sinLambda = 0.0;
        double cosLambda = 0.0;
        double sinSigma = 0.0;
        double cosSigma = 0.0;
        double sigma = 0.0;
        double sinAlpha = 0.0;
        double cosSqAlpha = 0.0;
        double cos2SigmaM = 0.0;
        while (Math.abs(lambda - lambdaP) > 1.0E-12) {
            double d;
            iterLimit -= 1.0;
            if (!(d > 0.0)) break;
            sinLambda = Math.sin(lambda);
            sinSigma = Math.sqrt(cosU2 * sinLambda * (cosU2 * sinLambda) + (cosU1 * sinU2 - sinU1 * cosU2 * (cosLambda = Math.cos(lambda))) * (cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
            if (sinSigma == 0.0) {
                return 0.0;
            }
            cosSigma = sinU1 * sinU2 + cosU1 * cosU2 * cosLambda;
            sigma = Math.atan2(sinSigma, cosSigma);
            sinAlpha = cosU1 * cosU2 * sinLambda / sinSigma;
            cosSqAlpha = 1.0 - sinAlpha * sinAlpha;
            cos2SigmaM = cosSigma - 2.0 * sinU1 * sinU2 / cosSqAlpha;
            if (Double.isNaN(cos2SigmaM)) {
                cos2SigmaM = 0.0;
            }
            double C = f / 16.0 * cosSqAlpha * (4.0 + f * (4.0 - 3.0 * cosSqAlpha));
            lambdaP = lambda;
            lambda = L + (1.0 - C) * f * sinAlpha * (sigma + C * sinSigma * (cos2SigmaM + C * cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM)));
        }
        if (iterLimit == 0.0) {
            return Double.NaN;
        }
        double uSq = cosSqAlpha * (a * a - b * b) / (b * b);
        double A = 1.0 + uSq / 16384.0 * (4096.0 + uSq * (-768.0 + uSq * (320.0 - 175.0 * uSq)));
        double B = uSq / 1024.0 * (256.0 + uSq * (-128.0 + uSq * (74.0 - 47.0 * uSq)));
        double deltaSigma = B * sinSigma * (cos2SigmaM + B / 4.0 * (cosSigma * (-1.0 + 2.0 * cos2SigmaM * cos2SigmaM) - B / 6.0 * cos2SigmaM * (-3.0 + 4.0 * sinSigma * sinSigma) * (-3.0 + 4.0 * cos2SigmaM * cos2SigmaM)));
        double distance = b * A * (sigma - deltaSigma);
        if (type == VincentyCalculationType.DISTANCE) {
            return distance;
        }
        double fwdAz = Math.toDegrees(Math.atan2(cosU2 * sinLambda, cosU1 * sinU2 - sinU1 * cosU2 * cosLambda));
        if (type == VincentyCalculationType.INITIAL_BEARING) {
            return fwdAz;
        }
        return Math.toDegrees(Math.atan2(cosU1 * sinLambda, -sinU1 * cosU2 + cosU1 * sinU2 * cosLambda));
    }

    static enum VincentyCalculationType {
        DISTANCE,
        FINAL_BEARING,
        INITIAL_BEARING;

    }
}

