/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

final class Point {
    public static final Point ORIGIN = new Point(0.0, 0.0);
    private final double x;
    private final double y;

    public Point(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Point rotate(Point p0, double thetaDeg) {
        double theta = StrictMath.toRadians(thetaDeg);
        double xr = p0.x + (StrictMath.cos(theta) * (this.x - p0.x) - StrictMath.sin(theta) * (this.y - p0.y));
        double yr = p0.y + (StrictMath.sin(theta) * (this.x - p0.x) + StrictMath.cos(theta) * (this.y - p0.y));
        return new Point(xr, yr);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Point{");
        sb.append("x=").append(this.x);
        sb.append(", y=").append(this.y);
        sb.append('}');
        return sb.toString();
    }

    public Point translate(double dx, double dy) {
        return new Point(this.x + dx, this.y + dy);
    }
}

