/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import net.maritimecloud.util.geometry.Position;
import net.maritimecloud.util.geometry.PositionTime;

public abstract class PositionReader {
    public abstract PositionTime getCurrentPosition();

    public static PositionReader fixedPosition(final Position position) {
        Objects.requireNonNull(position, "position is null");
        return new PositionReader(){

            @Override
            public PositionTime getCurrentPosition() {
                return position.withTime(System.currentTimeMillis());
            }
        };
    }

    public static PositionReader fixedPosition(final PositionTime positionTime) {
        Objects.requireNonNull(positionTime, "positionTime is null");
        return new PositionReader(){

            @Override
            public PositionTime getCurrentPosition() {
                return positionTime;
            }
        };
    }

    public static PositionReader nativeReader() {
        throw new UnsupportedOperationException("This method is not supported on the current platform");
    }

    public static PositionReader fromString(String pos) {
        if ((pos = pos.trim()).startsWith("file:///")) {
            try {
                URL url = new URL(pos);
                Path p = Paths.get(url.toURI());
                return new FileReader(p);
            }
            catch (IOException | URISyntaxException e) {
                throw new IllegalArgumentException("Not a valid file url '" + pos + "'", e);
            }
        }
        return PositionReader.fixedPosition(PositionTime.create(pos));
    }

    static class FileReader
    extends PositionReader {
        final Path p;

        FileReader(Path p) {
            this.p = Objects.requireNonNull(p);
        }

        @Override
        public PositionTime getCurrentPosition() {
            try {
                List<String> readAllLines = Files.readAllLines(this.p);
                if (readAllLines.size() > 0) {
                    return PositionTime.create(readAllLines.get(0));
                }
                throw new IllegalStateException("File was empty at '" + this.p + "'");
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not read position from '" + this.p + "'", e);
            }
        }
    }
}

