/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.geometry;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Objects;
import net.maritimecloud.internal.message.BinaryUtil;
import net.maritimecloud.message.MessageReader;
import net.maritimecloud.message.MessageSerializer;
import net.maritimecloud.message.MessageWriter;
import net.maritimecloud.util.Binary;
import net.maritimecloud.util.Timestamp;
import net.maritimecloud.util.geometry.CoordinateConverter;
import net.maritimecloud.util.geometry.Position;

public class PositionTime
extends Position {
    public static final MessageSerializer<PositionTime> SERIALIZER = new MessageSerializer<PositionTime>(){

        @Override
        public PositionTime read(MessageReader reader) throws IOException {
            return PositionTime.readFrom(reader);
        }

        @Override
        public void write(PositionTime message, MessageWriter writer) throws IOException {
            writer.writeDouble(1, "latitude", message.latitude);
            writer.writeDouble(2, "longitude", message.longitude);
            writer.writeInt64(3, "time", message.time);
        }
    };
    private static final long serialVersionUID = 1L;
    final long time;

    PositionTime(double latitude, double longitude, long time) {
        super(latitude, longitude);
        this.time = time;
    }

    public static PositionTime fromBinary(Binary b) {
        byte[] bytes = b.toByteArray();
        PositionTime pt = PositionTime.create((double)BinaryUtil.readInt(bytes, 0) / 1.0E7, (double)BinaryUtil.readInt(bytes, 4) / 1.0E7, BinaryUtil.readLong(bytes, 8));
        return pt;
    }

    @Override
    public Binary toBinary() {
        byte[] b = new byte[16];
        BinaryUtil.writeInt(this.getLatitudeAsInt(), b, 0);
        BinaryUtil.writeInt(this.getLongitudeAsInt(), b, 4);
        BinaryUtil.writeLong(this.getTime(), b, 8);
        return Binary.copyFrom(b);
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof PositionTime && this.equals((PositionTime)other);
    }

    @Override
    public boolean equals(Position other) {
        return other instanceof PositionTime && this.equals((PositionTime)other);
    }

    public boolean equals(PositionTime other) {
        return super.equals(other) && this.time == other.time;
    }

    public PositionTime extrapolatePosition(float cog, float sog, long time) {
        if (time < this.getTime()) {
            throw new IllegalArgumentException("'time' arguments cannot be earlier than 'pt1'. " + time + " " + this.getTime());
        }
        CoordinateConverter coordinateConverter = new CoordinateConverter(this.getLongitude(), this.getLatitude());
        double x0 = coordinateConverter.lon2x(this.getLongitude(), this.getLatitude());
        double y0 = coordinateConverter.lat2y(this.getLongitude(), this.getLatitude());
        int dt = (int)((time - this.getTime()) / 1000L);
        double dist = (double)((float)dt * sog) * 0.5144;
        double angle = CoordinateConverter.compass2cartesian(cog);
        double dx = Math.cos(angle / 180.0 * Math.PI) * dist;
        double dy = Math.sin(angle / 180.0 * Math.PI) * dist;
        double x1 = x0 + dx;
        double y1 = y0 + dy;
        double lon1 = coordinateConverter.x2Lon(x1, y1);
        double lat1 = coordinateConverter.y2Lat(x1, y1);
        return PositionTime.create(lat1, lon1, time);
    }

    public long getTime() {
        return this.time;
    }

    @Override
    public int hashCode() {
        long latLong = Double.doubleToLongBits(this.latitude);
        long lonLong = Double.doubleToLongBits(this.longitude);
        return (int)(this.time ^ latLong ^ latLong >>> 32) ^ (int)(this.time ^ lonLong ^ lonLong >>> 32);
    }

    public PositionTime interpolatedPosition(PositionTime laterPosition, long time) {
        Objects.requireNonNull(laterPosition);
        if (laterPosition.getTime() < this.getTime()) {
            throw new IllegalArgumentException("Provided position 1 must be earlier than position 2." + this.getTime() + " " + laterPosition.getTime());
        }
        if (time < this.getTime()) {
            throw new IllegalArgumentException("time parameter must be later than position 1's. " + time + " " + this.getTime());
        }
        if (time > laterPosition.getTime()) {
            throw new IllegalArgumentException("time parameter must be earlier than position 2's. " + time + " " + laterPosition.getTime());
        }
        double interpolatedLatitude = PositionTime.linearInterpolation(this.getLatitude(), this.getTime(), laterPosition.getLatitude(), laterPosition.getTime(), time);
        double interpolatedLongitude = PositionTime.linearInterpolation(this.getLongitude(), this.getTime(), laterPosition.getLongitude(), laterPosition.getTime(), time);
        return PositionTime.create(interpolatedLatitude, interpolatedLongitude, time);
    }

    public boolean positionEquals(Position other) {
        return super.equals(other);
    }

    @Override
    public String toString() {
        return "(" + this.getLatitude() + ", " + this.getLongitude() + ", time= " + this.time + ")";
    }

    public Timestamp timestamp() {
        return Timestamp.create(this.getTime());
    }

    public static PositionTime create(double latitude, double longitude) {
        return new PositionTime(latitude, longitude, System.currentTimeMillis());
    }

    public static PositionTime create(double latitude, double longitude, long time) {
        return new PositionTime(latitude, longitude, time);
    }

    public static PositionTime create(Position position, long time) {
        return PositionTime.create(position.latitude, position.longitude, time);
    }

    public static PositionTime create(String pos) {
        String[] spli = pos.split(",");
        if (spli.length == 2 || spli.length == 3) {
            double lon;
            double lat;
            DecimalFormat df = new DecimalFormat();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            symbols.setGroupingSeparator(' ');
            df.setDecimalFormatSymbols(symbols);
            try {
                lat = df.parse(spli[0]).doubleValue();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("'" + spli[0] + "' is not a valid degree latitude");
            }
            try {
                lon = df.parse(spli[1]).doubleValue();
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("'" + spli[1] + "' is not a valid degree longitude");
            }
            return PositionTime.create(lat, lon, System.currentTimeMillis());
        }
        throw new IllegalArgumentException("Position was not valid '" + pos + "' must be lat, lon in decimal degrees, example '23.23, -23.12'");
    }

    static double linearInterpolation(double y1, long x1, double y2, long x2, long x) {
        return y1 + (y2 - y1) / (double)(x2 - x1) * (double)(x - x1);
    }

    public static PositionTime readFrom(MessageReader r) throws IOException {
        double lat = r.readDouble(1, "latitude");
        double lon = r.readDouble(2, "longitude");
        long time = r.readInt64(3, "time", 0L);
        return PositionTime.create(lat, lon, time);
    }
}

