/*
 * Decompiled with CFR 0.152.
 */
package net.maritimecloud.util.units;

public enum DistanceUnit {
    KILOMETERS{

        @Override
        public double toKilometers(double distance) {
            return distance;
        }

        @Override
        public double toMeters(double distance) {
            return distance * 1000.0;
        }
    }
    ,
    METERS{

        @Override
        public double toMeters(double distance) {
            return distance;
        }
    }
    ,
    MILES{

        @Override
        public double toMeters(double distance) {
            return distance * 1609.344;
        }

        @Override
        public double toMiles(double distance) {
            return distance;
        }
    }
    ,
    NAUTICAL_MILES{

        @Override
        public double toMeters(double distance) {
            return distance * 1852.0;
        }

        @Override
        public double toNauticalMiles(double distance) {
            return distance;
        }
    };

    public static final double METERS_TO_MILES = 1609.344;
    public static final double METERS_TO_NAUTICAL_MILES = 1852.0;

    public double toKilometers(double distance) {
        return this.toMeters(distance) / 1000.0;
    }

    public abstract double toMeters(double var1);

    public double toMiles(double distance) {
        return this.toMeters(distance) * 1609.344;
    }

    public double toNauticalMiles(double distance) {
        return this.toMeters(distance) * 1852.0;
    }
}

