/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CRLReason;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import lombok.Generated;
import net.maritimeconnectivity.pki.CRLVerifier;
import net.maritimeconnectivity.pki.CertificateBuilder;
import net.maritimeconnectivity.pki.CertificateHandler;
import net.maritimeconnectivity.pki.PKIConfiguration;
import net.maritimeconnectivity.pki.Revocation;
import net.maritimeconnectivity.pki.RevocationInfo;
import net.maritimeconnectivity.pki.exception.PKIRuntimeException;
import net.maritimeconnectivity.pki.pkcs11.P11PKIConfiguration;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.OperatorCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CAHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CAHandler.class);
    private static final String HSM_EXCEPTION_MESSAGE = "This function can only be called when used with an HSM";
    private final CertificateBuilder certificateBuilder;
    private final PKIConfiguration pkiConfiguration;

    public void createSubCa(String subCaCertDN, String rootCAAlias, int validityPeriod) {
        X509Certificate subCaCert;
        String crlUrl;
        X500Name rootCertX500Name;
        KeyStore.PrivateKeyEntry rootCertEntry;
        KeyStore truststore;
        KeyStore subCaKeystore;
        KeyStore rootKeystore;
        try (FileInputStream rootKeystoreIS = new FileInputStream(this.pkiConfiguration.getRootCaKeystorePath());
             FileInputStream trustFis = new FileInputStream(this.pkiConfiguration.getTruststorePath());){
            rootKeystore = KeyStore.getInstance("jks");
            rootKeystore.load(rootKeystoreIS, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            subCaKeystore = KeyStore.getInstance("jks");
            if (Files.exists(Path.of(this.pkiConfiguration.getSubCaKeystorePath(), new String[0]), new LinkOption[0])) {
                try (FileInputStream subCaFis = new FileInputStream(this.pkiConfiguration.getSubCaKeystorePath());){
                    subCaKeystore.load(subCaFis, this.pkiConfiguration.getSubCaKeystorePassword().toCharArray());
                }
            } else {
                subCaKeystore.load(null, this.pkiConfiguration.getSubCaKeystorePassword().toCharArray());
            }
            truststore = KeyStore.getInstance(KeyStore.getDefaultType());
            truststore.load(trustFis, this.pkiConfiguration.getTruststorePassword().toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
        try {
            rootCertEntry = (KeyStore.PrivateKeyEntry)rootKeystore.getEntry(rootCAAlias, protectionParameter);
            rootCertX500Name = new JcaX509CertificateHolder((X509Certificate)rootCertEntry.getCertificate()).getSubject();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateEncodingException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        try {
            List<String> crlPoints = CRLVerifier.getCrlDistributionPoints((X509Certificate)rootCertEntry.getCertificate());
            crlUrl = crlPoints.getFirst();
        }
        catch (IOException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        KeyPair subCaKeyPair = CertificateBuilder.generateKeyPair(null);
        X500Name subCaCertX500Name = new X500Name(subCaCertDN);
        String alias = CertificateHandler.getElement(subCaCertX500Name, BCStyle.UID);
        if (alias == null || alias.trim().isEmpty()) {
            throw new PKIRuntimeException("UID must be defined for sub CA! It will be used as the sub CA alias.");
        }
        try {
            subCaCert = this.certificateBuilder.buildAndSignCert(this.certificateBuilder.generateSerialNumber(null), rootCertEntry.getPrivateKey(), rootCertEntry.getCertificate().getPublicKey(), subCaKeyPair.getPublic(), rootCertX500Name, subCaCertX500Name, null, "INTERMEDIATE", null, crlUrl, null, validityPeriod);
        }
        catch (Exception e) {
            throw new PKIRuntimeException("Could not create sub CA certificate!", e);
        }
        try (FileOutputStream trustFos = new FileOutputStream(this.pkiConfiguration.getTruststorePath());
             FileOutputStream subCaFos = new FileOutputStream(this.pkiConfiguration.getSubCaKeystorePath());){
            Certificate[] certChain = new Certificate[]{subCaCert, rootCertEntry.getCertificate()};
            subCaKeystore.setKeyEntry(alias, subCaKeyPair.getPrivate(), this.pkiConfiguration.getSubCaKeyPassword().toCharArray(), certChain);
            subCaKeystore.store(subCaFos, this.pkiConfiguration.getSubCaKeystorePassword().toCharArray());
            truststore.setCertificateEntry(alias, subCaCert);
            truststore.store(trustFos, this.pkiConfiguration.getTruststorePassword().toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
    }

    public void createSubCAPKCS11(String subCaCertDN, String rootCAAlias, PKIConfiguration subCaConfiguration, int validityPeriod) {
        X509Certificate subCaCert;
        String crlUrl;
        X500Name rootCertX500Name;
        KeyStore.PrivateKeyEntry rootCertEntry;
        KeyStore trustStore;
        KeyStore subCaStore;
        KeyStore rootStore;
        P11PKIConfiguration rootP11PKIConfiguration;
        block27: {
            block26: {
                PKIConfiguration pKIConfiguration = this.pkiConfiguration;
                if (!(pKIConfiguration instanceof P11PKIConfiguration)) break block26;
                rootP11PKIConfiguration = (P11PKIConfiguration)pKIConfiguration;
                if (subCaConfiguration instanceof P11PKIConfiguration) break block27;
            }
            throw new PKIRuntimeException(HSM_EXCEPTION_MESSAGE);
        }
        P11PKIConfiguration subCaP11PKIConfiguration = (P11PKIConfiguration)subCaConfiguration;
        rootP11PKIConfiguration.providerLogin();
        subCaP11PKIConfiguration.providerLogin();
        try (FileInputStream trustFileInputStream = new FileInputStream(rootP11PKIConfiguration.getTruststorePath());){
            rootStore = KeyStore.getInstance("PKCS11", rootP11PKIConfiguration.getProvider());
            rootStore.load(null, rootP11PKIConfiguration.getPkcs11Pin());
            subCaStore = KeyStore.getInstance("PKCS11", ((P11PKIConfiguration)subCaConfiguration).getProvider());
            subCaStore.load(null, subCaP11PKIConfiguration.getPkcs11Pin());
            trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(trustFileInputStream, this.pkiConfiguration.getTruststorePassword().toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            rootP11PKIConfiguration.providerLogout();
            subCaP11PKIConfiguration.providerLogout();
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        try {
            rootCertEntry = (KeyStore.PrivateKeyEntry)rootStore.getEntry(rootCAAlias, null);
            rootCertX500Name = new JcaX509CertificateHolder((X509Certificate)rootCertEntry.getCertificate()).getSubject();
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateEncodingException e) {
            rootP11PKIConfiguration.providerLogout();
            subCaP11PKIConfiguration.providerLogout();
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        try {
            List<String> crlPoints = CRLVerifier.getCrlDistributionPoints((X509Certificate)rootCertEntry.getCertificate());
            crlUrl = crlPoints.getFirst();
        }
        catch (IOException e) {
            rootP11PKIConfiguration.providerLogout();
            subCaP11PKIConfiguration.providerLogout();
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        KeyPair subCaKeyPair = CertificateBuilder.generateKeyPairPKCS11(subCaP11PKIConfiguration);
        X500Name subCaCertX500Name = new X500Name(subCaCertDN);
        String alias = CertificateHandler.getElement(subCaCertX500Name, BCStyle.UID);
        if (alias == null || alias.trim().isEmpty()) {
            rootP11PKIConfiguration.providerLogout();
            subCaP11PKIConfiguration.providerLogout();
            throw new PKIRuntimeException("UID must be defined for sub CA! It will be used as the sub CA alias.");
        }
        try {
            subCaCert = this.certificateBuilder.buildAndSignCert(this.certificateBuilder.generateSerialNumber(rootP11PKIConfiguration), rootCertEntry.getPrivateKey(), rootCertEntry.getCertificate().getPublicKey(), subCaKeyPair.getPublic(), rootCertX500Name, subCaCertX500Name, null, "INTERMEDIATE", null, crlUrl, rootP11PKIConfiguration.getProvider(), validityPeriod);
        }
        catch (Exception e) {
            rootP11PKIConfiguration.providerLogout();
            subCaP11PKIConfiguration.providerLogout();
            throw new PKIRuntimeException("Could not create sub CA certificate!", e);
        }
        try (FileOutputStream trustFos = new FileOutputStream(this.pkiConfiguration.getTruststorePath());){
            Certificate[] certChain = new Certificate[]{subCaCert, rootCertEntry.getCertificate()};
            subCaStore.setKeyEntry(alias, subCaKeyPair.getPrivate(), null, certChain);
            trustStore.setCertificateEntry(alias, subCaCert);
            trustStore.store(trustFos, this.pkiConfiguration.getTruststorePassword().toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            rootP11PKIConfiguration.providerLogout();
            subCaP11PKIConfiguration.providerLogout();
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        rootP11PKIConfiguration.providerLogout();
        subCaP11PKIConfiguration.providerLogout();
    }

    public void initRootCA(String rootCertX500Name, String crlUrl, String rootCAAlias, int validityPeriod) {
        KeyPair rootCAKeyPair = CertificateBuilder.generateKeyPair(null);
        try (FileOutputStream rootFileOutputStream = new FileOutputStream(this.pkiConfiguration.getRootCaKeystorePath());
             FileOutputStream trustStoreOutputStream = new FileOutputStream(this.pkiConfiguration.getTruststorePath());){
            KeyStore rootCAKeyStore = KeyStore.getInstance("jks");
            rootCAKeyStore.load(null, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            X509Certificate cacert = this.certificateBuilder.buildAndSignCert(this.certificateBuilder.generateSerialNumber(null), rootCAKeyPair.getPrivate(), rootCAKeyPair.getPublic(), rootCAKeyPair.getPublic(), new X500Name(rootCertX500Name), new X500Name(rootCertX500Name), null, "ROOTCA", null, crlUrl, null, validityPeriod);
            Certificate[] certChain = new Certificate[]{cacert};
            rootCAKeyStore.setKeyEntry(rootCAAlias, rootCAKeyPair.getPrivate(), this.pkiConfiguration.getRootCaKeyPassword().toCharArray(), certChain);
            rootCAKeyStore.store(rootFileOutputStream, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            rootCAKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            rootCAKeyStore.load(null, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, this.pkiConfiguration.getTruststorePassword().toCharArray());
            trustStore.setCertificateEntry(rootCAAlias, cacert);
            trustStore.store(trustStoreOutputStream, this.pkiConfiguration.getTruststorePassword().toCharArray());
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | OperatorCreationException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
    }

    public void initRootCAPKCS11(String rootCertX500Name, String crlUrl, String rootCAAlias, int validityPeriod) {
        PKIConfiguration pKIConfiguration = this.pkiConfiguration;
        if (!(pKIConfiguration instanceof P11PKIConfiguration)) {
            throw new PKIRuntimeException(HSM_EXCEPTION_MESSAGE);
        }
        P11PKIConfiguration p11PKIConfiguration = (P11PKIConfiguration)pKIConfiguration;
        p11PKIConfiguration.providerLogin();
        KeyPair caKeyPair = CertificateBuilder.generateKeyPairPKCS11(p11PKIConfiguration);
        try (FileOutputStream tsFos = new FileOutputStream(this.pkiConfiguration.getTruststorePath());){
            KeyStore rootKeyStore = KeyStore.getInstance("PKCS11", p11PKIConfiguration.getProvider());
            rootKeyStore.load(null, p11PKIConfiguration.getPkcs11Pin());
            X509Certificate caCert = this.certificateBuilder.buildAndSignCert(this.certificateBuilder.generateSerialNumber(p11PKIConfiguration), caKeyPair.getPrivate(), caKeyPair.getPublic(), caKeyPair.getPublic(), new X500Name(rootCertX500Name), new X500Name(rootCertX500Name), null, "ROOTCA", null, crlUrl, p11PKIConfiguration.getProvider(), validityPeriod);
            Certificate[] certChain = new Certificate[]{caCert};
            rootKeyStore.setKeyEntry(rootCAAlias, caKeyPair.getPrivate(), null, certChain);
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, this.pkiConfiguration.getTruststorePassword().toCharArray());
            trustStore.setCertificateEntry(rootCAAlias, caCert);
            trustStore.store(tsFos, this.pkiConfiguration.getTruststorePassword().toCharArray());
            p11PKIConfiguration.providerLogout();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException | OperatorCreationException e) {
            p11PKIConfiguration.providerLogout();
            throw new PKIRuntimeException(e.getMessage(), e);
        }
    }

    public List<RevocationInfo> loadRevocationFile(String revocationFile) {
        String cvsSplitBy = ";";
        ArrayList<RevocationInfo> revocationInfos = new ArrayList<RevocationInfo>();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try (BufferedReader br = new BufferedReader(new FileReader(revocationFile));){
            String csvLine;
            while ((csvLine = br.readLine()) != null) {
                if (csvLine.trim().isEmpty()) continue;
                String[] revocationInfoSplit = csvLine.split(cvsSplitBy);
                if (revocationInfoSplit.length != 3) {
                    throw new PKIRuntimeException("Missing info from line: " + csvLine);
                }
                RevocationInfo info = new RevocationInfo();
                info.setSerialNumber(new BigInteger(revocationInfoSplit[0].trim()));
                info.setRevokeReason(CRLReason.values()[Revocation.getCRLReasonFromString(revocationInfoSplit[1].trim().toLowerCase())]);
                Date revokedAt = format.parse(revocationInfoSplit[2].trim());
                if (revokedAt == null) {
                    throw new PKIRuntimeException("Invalid date format!");
                }
                info.setRevokedAt(revokedAt);
                revocationInfos.add(info);
            }
        }
        catch (FileNotFoundException e) {
            throw new PKIRuntimeException("Could not find the revocation info file!", e);
        }
        catch (IOException e) {
            throw new PKIRuntimeException(e);
        }
        catch (ParseException e) {
            throw new PKIRuntimeException("Invalid date format!", e);
        }
        return revocationInfos;
    }

    public void generateRootCRL(String outputCaCrlPath, String revocationFile, String rootCAAlias) {
        List<RevocationInfo> revocationInfos = this.loadRevocationFile(revocationFile);
        try (FileInputStream readStream = new FileInputStream(this.pkiConfiguration.getRootCaKeystorePath());){
            KeyStore rootKeyStore = KeyStore.getInstance("jks");
            rootKeyStore.load(readStream, this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(this.pkiConfiguration.getRootCaKeystorePassword().toCharArray());
            KeyStore.PrivateKeyEntry rootCertEntry = (KeyStore.PrivateKeyEntry)rootKeyStore.getEntry(rootCAAlias, protectionParameter);
            String rootCertX500Name = new JcaX509CertificateHolder((X509Certificate)rootCertEntry.getCertificate()).getSubject().toString();
            Revocation.generateRootCACRL(rootCertX500Name, revocationInfos, rootCertEntry, outputCaCrlPath, null);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException e) {
            throw new PKIRuntimeException("Unable to generate RootCACRL", e);
        }
        catch (CertificateException e) {
            throw new PKIRuntimeException("Could not load root certificate!", e);
        }
        catch (FileNotFoundException e) {
            throw new PKIRuntimeException("Could not find root keystore!", e);
        }
        catch (IOException e) {
            throw new PKIRuntimeException("Could not load root keystore!", e);
        }
    }

    public void generateRootCRLP11(String outputCaCrlPath, String revocationFile, String rootCAAlias) {
        PKIConfiguration pKIConfiguration = this.pkiConfiguration;
        if (!(pKIConfiguration instanceof P11PKIConfiguration)) {
            throw new PKIRuntimeException(HSM_EXCEPTION_MESSAGE);
        }
        P11PKIConfiguration p11PKIConfiguration = (P11PKIConfiguration)pKIConfiguration;
        List<RevocationInfo> revocationInfos = this.loadRevocationFile(revocationFile);
        p11PKIConfiguration.providerLogin();
        try {
            KeyStore rootKeyStore = KeyStore.getInstance("PKCS11", p11PKIConfiguration.getProvider());
            rootKeyStore.load(null, p11PKIConfiguration.getPkcs11Pin());
            KeyStore.PrivateKeyEntry rootCertEntry = (KeyStore.PrivateKeyEntry)rootKeyStore.getEntry(rootCAAlias, null);
            String rootCertX500Name = new JcaX509CertificateHolder((X509Certificate)rootCertEntry.getCertificate()).getSubject().toString();
            Revocation.generateRootCACRL(rootCertX500Name, revocationInfos, rootCertEntry, outputCaCrlPath, p11PKIConfiguration.getProvider());
            p11PKIConfiguration.providerLogout();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
            p11PKIConfiguration.providerLogout();
            throw new PKIRuntimeException("Could not generate CRL", e);
        }
    }

    @Generated
    public CAHandler(CertificateBuilder certificateBuilder, PKIConfiguration pkiConfiguration) {
        this.certificateBuilder = certificateBuilder;
        this.pkiConfiguration = pkiConfiguration;
    }
}

