/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import lombok.Generated;
import net.maritimeconnectivity.pki.RevocationInfo;
import net.maritimeconnectivity.pki.ocsp.CertStatus;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CRLVerifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CRLVerifier.class);

    public static RevocationInfo verifyCertificateCRL(X509Certificate cert) {
        try {
            List<String> crlDistPoints = CRLVerifier.getCrlDistributionPoints(cert);
            for (String crlDP : crlDistPoints) {
                X509CRL crl = CRLVerifier.downloadCRL(crlDP);
                if (!crl.isRevoked(cert)) continue;
                X509CRLEntry entry = crl.getRevokedCertificate(cert.getSerialNumber());
                return new RevocationInfo(entry.getSerialNumber(), entry.getRevocationReason(), entry.getRevocationDate(), CertStatus.REVOKED);
            }
            return new RevocationInfo(cert.getSerialNumber(), null, null, CertStatus.GOOD);
        }
        catch (Exception ex) {
            log.error("An Exception was thrown during CRL verification!", (Throwable)ex);
            return new RevocationInfo(cert.getSerialNumber(), null, null, CertStatus.UNKNOWN);
        }
    }

    public static RevocationInfo verifyCertificateCRL(X509Certificate cert, X509CRL crl) {
        try {
            if (crl.isRevoked(cert)) {
                X509CRLEntry entry = crl.getRevokedCertificate(cert.getSerialNumber());
                return new RevocationInfo(entry.getSerialNumber(), entry.getRevocationReason(), entry.getRevocationDate(), CertStatus.REVOKED);
            }
            return new RevocationInfo(cert.getSerialNumber(), null, null, CertStatus.GOOD);
        }
        catch (Exception ex) {
            log.error("An Exception was thrown during CRL verification!", (Throwable)ex);
            return new RevocationInfo(cert.getSerialNumber(), null, null, CertStatus.UNKNOWN);
        }
    }

    public static X509CRL downloadCRL(String crlURL) throws IOException, CertificateException, NamingException, CRLException, URISyntaxException {
        if (crlURL.startsWith("http://") || crlURL.startsWith("https://") || crlURL.startsWith("ftp://")) {
            return CRLVerifier.downloadCRLFromWeb(crlURL);
        }
        if (crlURL.startsWith("ldap://")) {
            return CRLVerifier.downloadCRLFromLDAP(crlURL);
        }
        throw new CRLException("Cannot download CRL from certificate distribution point: " + crlURL);
    }

    public static X509CRL downloadCRLFromLDAP(String ldapURL) throws NamingException, CertificateException, CRLException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        InitialDirContext ctx = new InitialDirContext(new Hashtable(env));
        Attributes avals = ctx.getAttributes("");
        Attribute aval = avals.get("certificateRevocationList;binary");
        byte[] val = (byte[])aval.get();
        if (val == null || val.length == 0) {
            throw new CRLException("Can not download CRL from: " + ldapURL);
        }
        ByteArrayInputStream inStream = new ByteArrayInputStream(val);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return (X509CRL)cf.generateCRL(inStream);
    }

    public static X509CRL downloadCRLFromWeb(String crlURL) throws IOException, CRLException, CertificateException {
        URL url = URI.create(crlURL).toURL();
        try (InputStream crlStream = url.openStream();){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = (X509CRL)cf.generateCRL(crlStream);
            return x509CRL;
        }
    }

    public static X509CRL loadCRLFromFile(String path) throws IOException, CRLException, CertificateException {
        try (FileInputStream fis = new FileInputStream(path);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509CRL x509CRL = (X509CRL)cf.generateCRL(fis);
            return x509CRL;
        }
    }

    public static List<String> getCrlDistributionPoints(X509Certificate cert) throws IOException {
        CRLDistPoint crlDistPoint;
        byte[] crldpExt = cert.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (crldpExt == null) {
            return new ArrayList<String>();
        }
        try (ASN1InputStream oAsnInStream = new ASN1InputStream(crldpExt);){
            DEROctetString dosCrlDP = (DEROctetString)oAsnInStream.readObject();
            byte[] crldpExtOctets = dosCrlDP.getOctets();
            ASN1InputStream oAsnInStream2 = new ASN1InputStream((InputStream)new ByteArrayInputStream(crldpExtOctets));
            crlDistPoint = CRLDistPoint.getInstance((Object)oAsnInStream2.readObject());
            oAsnInStream2.close();
        }
        ArrayList<String> crlUrls = new ArrayList<String>();
        for (DistributionPoint dp : crlDistPoint.getDistributionPoints()) {
            GeneralName[] genNames;
            DistributionPointName dpn = dp.getDistributionPoint();
            if (dpn == null || dpn.getType() != 0) continue;
            for (GeneralName genName : genNames = GeneralNames.getInstance((Object)dpn.getName()).getNames()) {
                if (genName.getTagNo() != 6) continue;
                String url = ASN1IA5String.getInstance((Object)genName.getName()).getString();
                crlUrls.add(url);
            }
        }
        return crlUrls;
    }

    @Generated
    private CRLVerifier() {
    }
}

