/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki;

import java.math.BigInteger;
import java.security.AuthProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.ECGenParameterSpec;
import java.time.Instant;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import lombok.Generated;
import lombok.NonNull;
import net.maritimeconnectivity.pki.KeystoreHandler;
import net.maritimeconnectivity.pki.PKIConfiguration;
import net.maritimeconnectivity.pki.exception.PKIRuntimeException;
import net.maritimeconnectivity.pki.pkcs11.P11PKIConfiguration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.OtherName;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.BigIntegers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateBuilder.class);
    private final KeystoreHandler keystoreHandler;
    private final SecureRandom random;
    private static final Set<Character> RESERVED_CHARACTERS = new HashSet<Character>(Arrays.asList(Character.valueOf(','), Character.valueOf('+'), Character.valueOf('\"'), Character.valueOf('\\'), Character.valueOf('<'), Character.valueOf('>'), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('/')));

    public CertificateBuilder(@NonNull KeystoreHandler keystoreHandler) {
        if (keystoreHandler == null) {
            throw new NullPointerException("keystoreHandler is marked non-null but is null");
        }
        this.keystoreHandler = keystoreHandler;
        this.random = new SecureRandom();
    }

    public X509Certificate buildAndSignCert(BigInteger serialNumber, PrivateKey signerPrivateKey, PublicKey signerPublicKey, PublicKey subjectPublicKey, X500Name issuer, X500Name subject, Map<String, String> customAttrs, String type, String ocspUrl, String crlUrl, AuthProvider p11AuthProvider, int validityPeriod) throws NoSuchAlgorithmException, CertIOException, OperatorCreationException, CertificateException {
        Date now = Date.from(Instant.now());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(now);
        if (validityPeriod <= 0) {
            throw new IllegalArgumentException("The validity period length should be a positive integer number.");
        }
        cal.add(2, validityPeriod);
        Date expire = cal.getTime();
        JcaX509v3CertificateBuilder certV3Bldr = new JcaX509v3CertificateBuilder(issuer, serialNumber, now, expire, subject, subjectPublicKey);
        JcaX509ExtensionUtils extensionUtil = new JcaX509ExtensionUtils();
        if ("ROOTCA".equals(type)) {
            certV3Bldr = certV3Bldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new X509KeyUsage(230));
        } else if ("INTERMEDIATE".equals(type)) {
            certV3Bldr = certV3Bldr.addExtension(Extension.basicConstraints, true, (ASN1Encodable)new BasicConstraints(true)).addExtension(Extension.keyUsage, true, (ASN1Encodable)new X509KeyUsage(230));
        } else {
            GeneralName[] genNames = null;
            if (customAttrs != null && !customAttrs.isEmpty()) {
                genNames = new GeneralName[customAttrs.size()];
                Iterator<Map.Entry<String, String>> it = customAttrs.entrySet().iterator();
                int idx = 0;
                while (it.hasNext()) {
                    Map.Entry<String, String> pair = it.next();
                    if ("2".equals(pair.getKey())) {
                        genNames[idx] = new GeneralName(2, pair.getValue());
                    } else {
                        OtherName otherName = new OtherName(new ASN1ObjectIdentifier(pair.getKey()), (ASN1Encodable)new DERUTF8String(pair.getValue()));
                        genNames[idx] = new GeneralName(0, (ASN1Encodable)otherName);
                    }
                    ++idx;
                }
            }
            if (genNames != null) {
                certV3Bldr = certV3Bldr.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new GeneralNames(genNames));
            }
        }
        certV3Bldr = certV3Bldr.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)extensionUtil.createAuthorityKeyIdentifier(signerPublicKey)).addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)extensionUtil.createSubjectKeyIdentifier(subjectPublicKey));
        DistributionPointName distPointOne = new DistributionPointName(new GeneralNames(new GeneralName(6, crlUrl)));
        DistributionPoint[] distPoints = new DistributionPoint[]{new DistributionPoint(distPointOne, null, null)};
        certV3Bldr.addExtension(Extension.cRLDistributionPoints, false, (ASN1Encodable)new CRLDistPoint(distPoints));
        if (ocspUrl != null) {
            GeneralName ocspName = new GeneralName(6, ocspUrl);
            AuthorityInformationAccess authorityInformationAccess = new AuthorityInformationAccess(X509ObjectIdentifiers.ocspAccessMethod, ocspName);
            certV3Bldr.addExtension(Extension.authorityInfoAccess, false, (ASN1Encodable)authorityInformationAccess);
        }
        JcaContentSignerBuilder builder = new JcaContentSignerBuilder("SHA384withECDSA");
        if (p11AuthProvider != null) {
            builder.setProvider((Provider)p11AuthProvider);
        } else {
            builder.setProvider("BC");
        }
        ContentSigner signer = builder.build(signerPrivateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certV3Bldr.build(signer));
    }

    public X509Certificate generateCertForEntity(BigInteger serialNumber, String country, String orgName, String type, String callName, String email, String uid, int validityPeriod, PublicKey publicKey, Map<String, String> customAttr, String signingAlias, String baseCrlOcspURI, AuthProvider p11AuthProvider) throws CertificateException, OperatorCreationException, CertIOException, NoSuchAlgorithmException {
        String[] locales;
        KeyStore.PrivateKeyEntry signingCertEntry = this.keystoreHandler.getSigningCertEntry(signingAlias);
        Certificate signingCert = signingCertEntry.getCertificate();
        X509Certificate signingX509Cert = (X509Certificate)signingCert;
        String orgCountryCode = country;
        for (String countryCode : locales = Locale.getISOCountries()) {
            Locale loc = Locale.of("", countryCode);
            if (!loc.getDisplayCountry(Locale.ENGLISH).equals(orgCountryCode)) continue;
            orgCountryCode = loc.getCountry();
            break;
        }
        String subjectDn = "C=" + CertificateBuilder.escapeSpecialCharacters(orgCountryCode) + ", O=" + CertificateBuilder.escapeSpecialCharacters(orgName) + ", OU=" + CertificateBuilder.escapeSpecialCharacters(type) + ", CN=" + CertificateBuilder.escapeSpecialCharacters(callName) + ", UID=" + CertificateBuilder.escapeSpecialCharacters(uid);
        if (email != null && !email.isEmpty()) {
            subjectDn = subjectDn + ", E=" + CertificateBuilder.escapeSpecialCharacters(email);
        }
        String ocspUrl = baseCrlOcspURI + "ocsp/" + signingAlias;
        String crlUrl = baseCrlOcspURI + "crl/" + signingAlias;
        return this.buildAndSignCert(serialNumber, signingCertEntry.getPrivateKey(), signingX509Cert.getPublicKey(), publicKey, new JcaX509CertificateHolder(signingX509Cert).getSubject(), new X500Name(subjectDn), customAttr, "ENTITY", ocspUrl, crlUrl, p11AuthProvider, validityPeriod);
    }

    public static KeyPair generateKeyPair(PKIConfiguration pkiConfiguration) {
        KeyPairGenerator g;
        ECGenParameterSpec ecGenSpec = new ECGenParameterSpec("secp384r1");
        try {
            g = KeyPairGenerator.getInstance("ECDSA", "BC");
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        try {
            SecureRandom secureRandom;
            if (pkiConfiguration instanceof P11PKIConfiguration) {
                P11PKIConfiguration p11PKIConfiguration = (P11PKIConfiguration)pkiConfiguration;
                secureRandom = SecureRandom.getInstance("PKCS11", p11PKIConfiguration.getProvider());
            } else {
                secureRandom = new SecureRandom();
            }
            g.initialize(ecGenSpec, secureRandom);
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        return g.generateKeyPair();
    }

    public static KeyPair generateKeyPairPKCS11(P11PKIConfiguration p11PKIConfiguration) {
        KeyPairGenerator g;
        ECGenParameterSpec ecGenSpec = new ECGenParameterSpec("secp384r1");
        try {
            g = KeyPairGenerator.getInstance("EC", p11PKIConfiguration.getProvider());
            g.initialize(ecGenSpec, SecureRandom.getInstance("PKCS11", p11PKIConfiguration.getProvider()));
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        return g.generateKeyPair();
    }

    public BigInteger generateSerialNumber(PKIConfiguration pkiConfiguration) {
        BigInteger maxValue = new BigInteger("730750818665451459101842416358141509827966271487");
        BigInteger minValue = BigInteger.ONE;
        if (pkiConfiguration instanceof P11PKIConfiguration) {
            P11PKIConfiguration p11PKIConfiguration = (P11PKIConfiguration)pkiConfiguration;
            try {
                return BigIntegers.createRandomInRange((BigInteger)minValue, (BigInteger)maxValue, (SecureRandom)SecureRandom.getInstance("PKCS11", p11PKIConfiguration.getProvider()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new PKIRuntimeException(e.getMessage(), e);
            }
        }
        return BigIntegers.createRandomInRange((BigInteger)minValue, (BigInteger)maxValue, (SecureRandom)this.random);
    }

    public static String escapeSpecialCharacters(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            Object escaped = RESERVED_CHARACTERS.contains(Character.valueOf(c)) ? "\\" + c : (c == '\u0000' ? "\\00" : (c == '\f' ? "\\0A" : (c == '\r' ? "\\0D" : String.valueOf(c))));
            stringBuilder.append((String)escaped);
        }
        Object escapedString = stringBuilder.toString();
        if (((String)escapedString).startsWith("#") || ((String)escapedString).startsWith(" ")) {
            escapedString = "\\" + (String)escapedString;
        }
        if (((String)escapedString).endsWith(" ")) {
            String tmp = ((String)escapedString).substring(0, ((String)escapedString).length() - 1);
            escapedString = tmp + "\\ ";
        }
        return escapedString;
    }
}

