/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import lombok.Generated;
import net.maritimeconnectivity.pki.PKIIdentity;
import net.maritimeconnectivity.pki.exception.PKIRuntimeException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertificateHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CertificateHandler.class);

    public static boolean verifyCertificate(PublicKey verificationPubKey, X509Certificate certToVerify, Date verificationDate) {
        boolean signatureValidity;
        ContentVerifierProvider contentVerifierProvider;
        JcaX509CertificateHolder certHolder;
        try {
            certHolder = new JcaX509CertificateHolder(certToVerify);
        }
        catch (CertificateEncodingException e) {
            log.error("Could not create JcaX509CertificateHolder", (Throwable)e);
            return false;
        }
        try {
            contentVerifierProvider = new JcaContentVerifierProviderBuilder().setProvider("BC").build(verificationPubKey);
        }
        catch (OperatorCreationException e) {
            log.error("Could not create ContentVerifierProvider from public key", (Throwable)e);
            return false;
        }
        if (contentVerifierProvider == null) {
            log.error("Created ContentVerifierProvider from root public key is null");
            return false;
        }
        try {
            signatureValidity = certHolder.isSignatureValid(contentVerifierProvider);
        }
        catch (CertException e) {
            log.error("Error when trying to validate signature", (Throwable)e);
            return false;
        }
        if (signatureValidity) {
            if (verificationDate == null) {
                verificationDate = Date.from(Instant.now());
            }
            if (verificationDate.after(certToVerify.getNotBefore()) && verificationDate.before(certToVerify.getNotAfter())) {
                return true;
            }
            log.debug("Out of certificate validity period.");
            return false;
        }
        log.debug("Certificate does not seem to be valid!");
        return false;
    }

    public static boolean verifyCertificateChain(X509Certificate certificate, KeyStore ks) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, InvalidAlgorithmParameterException, CertPathValidatorException {
        List<X509Certificate> certList = Collections.singletonList(certificate);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        CertPath certPath = cf.generateCertPath(certList);
        CertPathValidator validator = CertPathValidator.getInstance("PKIX");
        PKIXRevocationChecker rc = (PKIXRevocationChecker)validator.getRevocationChecker();
        rc.setOptions(EnumSet.of(PKIXRevocationChecker.Option.SOFT_FAIL));
        PKIXParameters pkixp = new PKIXParameters(ks);
        pkixp.addCertPathChecker(rc);
        pkixp.setRevocationEnabled(true);
        PKIXCertPathValidatorResult pcpvr = (PKIXCertPathValidatorResult)validator.validate(certPath, pkixp);
        return pcpvr != null;
    }

    public static String getPemFromEncoded(String type, byte[] encoded) throws IOException {
        String pemFormat = "";
        StringWriter stringWriter = new StringWriter();
        try (PemWriter pemWriter = new PemWriter((Writer)stringWriter);){
            pemWriter.writeObject((PemObjectGenerator)new PemObject(type, encoded));
            pemWriter.flush();
            pemFormat = stringWriter.toString();
        }
        return pemFormat;
    }

    public static byte[] createOutputKeystore(String type, String alias, String password, PrivateKey privateKey, X509Certificate certificate) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            KeyStore ks = type.equals("JKS") ? KeyStore.getInstance(type) : KeyStore.getInstance(type, "BC");
            ks.load(null);
            ks.setKeyEntry(alias, privateKey, password.toCharArray(), new Certificate[]{certificate});
            ks.store(bos, password.toCharArray());
            return bos.toByteArray();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
            throw new PKIRuntimeException(e);
        }
    }

    public static X509Certificate getCertFromNginxHeader(String certificateHeader) {
        String body;
        Object certificateContent = URLDecoder.decode(certificateHeader, StandardCharsets.UTF_8);
        if (((String)certificateContent).startsWith("-----BEGIN CERTIFICATE-----") && ((String)certificateContent).contains("-----END CERTIFICATE-----") && (body = ((String)certificateContent).split("-----BEGIN CERTIFICATE-----")[1].split("-----END CERTIFICATE-----")[0]).contains(" ")) {
            body = body.replace(" ", "+");
            certificateContent = "-----BEGIN CERTIFICATE-----" + body + "-----END CERTIFICATE-----";
        }
        if (((String)certificateContent).trim().isEmpty() || ((String)certificateContent).length() < 10) {
            log.debug("No certificate content found");
            return null;
        }
        return CertificateHandler.getCertFromPem((String)certificateContent);
    }

    public static X509Certificate getCertFromPem(String pemCertificate) {
        X509Certificate userCertificate;
        CertificateFactory certificateFactory;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            log.error("Exception while creating CertificateFactory", (Throwable)e);
            return null;
        }
        try {
            userCertificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(pemCertificate.getBytes(StandardCharsets.UTF_8)));
        }
        catch (CertificateException e) {
            log.error("Exception while converting certificate extracted from header", (Throwable)e);
            return null;
        }
        log.debug("Certificate was extracted from the header");
        return userCertificate;
    }

    public static PKIIdentity getIdentityFromCert(X509Certificate userCertificate) {
        PKIIdentity identity = new PKIIdentity();
        String certDN = userCertificate.getSubjectX500Principal().getName();
        RDN[] rdns = IETFUtils.rDNsFromString((String)certDN, (X500NameStyle)BCStyle.INSTANCE);
        String name = CertificateHandler.getElement(rdns, BCStyle.CN);
        String uid = CertificateHandler.getElement(rdns, BCStyle.UID);
        identity.setMrn(uid);
        identity.setDn(certDN);
        identity.setCn(name);
        identity.setSn(name);
        identity.setO(CertificateHandler.getElement(rdns, BCStyle.O));
        identity.setOu(CertificateHandler.getElement(rdns, BCStyle.OU));
        identity.setCountry(CertificateHandler.getElement(rdns, BCStyle.C));
        identity.setEmail(CertificateHandler.getElement(rdns, BCStyle.EmailAddress));
        if (certDN.contains("1.2.840.113549.1.9.1")) {
            CharSequence[] parts = certDN.split(",");
            for (int i = 0; i < parts.length; ++i) {
                if (!parts[i].startsWith("1.2.840.113549.1.9.1")) continue;
                parts[i] = String.format("E=%s", identity.getEmail());
                break;
            }
            identity.setDn(String.join((CharSequence)",", parts));
        }
        String lastName = "";
        String firstName = "";
        if (name != null && name.split("\\w +\\w").length > 1) {
            lastName = name.substring(name.lastIndexOf(32) + 1);
            firstName = name.substring(0, name.lastIndexOf(32));
        } else {
            firstName = name;
        }
        identity.setFirstName(firstName);
        identity.setLastName(lastName);
        log.debug("Parsed certificate, name: {}", (Object)name);
        Collection<List<?>> san = null;
        try {
            san = userCertificate.getSubjectAlternativeNames();
        }
        catch (CertificateParsingException e) {
            log.warn("could not extract info from Subject Alternative Names - will be ignored.");
        }
        if (san != null) {
            StringBuilder permissions = new StringBuilder();
            block38: for (List<?> item : san) {
                Integer type = (Integer)item.getFirst();
                if (type == 0) {
                    String value;
                    String oid;
                    try (ASN1InputStream decoder = new ASN1InputStream((byte[])item.toArray()[1]);){
                        DLSequence seq = (DLSequence)decoder.readObject();
                        ASN1ObjectIdentifier asnOID = (ASN1ObjectIdentifier)seq.getObjectAt(0);
                        ASN1Encodable encoded = seq.getObjectAt(1);
                        oid = asnOID.getId();
                        encoded = CertificateHandler.getBaseObject(encoded);
                        value = ((DERUTF8String)encoded).getString();
                    }
                    catch (IOException e) {
                        log.error("Error decoding subjectAltName: {}", (Object)e.getMessage());
                        continue;
                    }
                    log.debug("oid: {}, value: {}", (Object)oid, (Object)value);
                    switch (oid) {
                        case "2.25.323100633285601570573910217875371967771": {
                            identity.setFlagState(value);
                            break;
                        }
                        case "2.25.208070283325144527098121348946972755227": {
                            identity.setCallSign(value);
                            break;
                        }
                        case "2.25.291283622413876360871493815653100799259": {
                            identity.setImoNumber(value);
                            break;
                        }
                        case "2.25.328433707816814908768060331477217690907": {
                            identity.setMmsiNumber(value);
                            break;
                        }
                        case "2.25.107857171638679641902842130101018412315": {
                            identity.setAisShipType(value);
                            break;
                        }
                        case "2.25.285632790821948647314354670918887798603": {
                            identity.setPortOfRegister(value);
                            break;
                        }
                        case "2.25.271477598449775373676560215839310464283": {
                            identity.setMrn(value);
                            break;
                        }
                        case "2.25.133833610339604538603087183843785923701": {
                            identity.setMrnSubsidiary(value);
                            break;
                        }
                        case "2.25.171344478791913547554566856023141401757": {
                            identity.setHomeMmsUrl(value);
                            break;
                        }
                        case "2.25.268095117363717005222833833642941669792": {
                            identity.setShipMrn(value);
                            break;
                        }
                        case "2.25.245076023612240385163414144226581328607": {
                            identity.setUrl(value);
                            break;
                        }
                        case "2.25.174437629172304915481663724171734402331": {
                            if (value.trim().isEmpty()) continue block38;
                            if (permissions.isEmpty()) {
                                permissions = new StringBuilder(value);
                                break;
                            }
                            permissions.append(',').append(value);
                            break;
                        }
                        default: {
                            log.error("Unknown OID!");
                            break;
                        }
                    }
                    continue;
                }
                log.warn("SubjectAltName of invalid type found: {}", (Object)type);
            }
            if (!permissions.isEmpty()) {
                identity.setPermissions(permissions.toString());
            }
        }
        return identity;
    }

    private static ASN1Encodable getBaseObject(ASN1Encodable encoded) {
        ASN1TaggedObject asn1TaggedObject;
        encoded = ((ASN1TaggedObject)encoded).getBaseObject();
        while (encoded instanceof ASN1TaggedObject && (asn1TaggedObject = (ASN1TaggedObject)encoded).getBaseObject() != null) {
            encoded = asn1TaggedObject.getBaseObject();
        }
        return encoded;
    }

    public static String getElement(X500Name x500name, ASN1ObjectIdentifier objectId) {
        RDN[] rdns;
        if (x500name != null && objectId != null && (rdns = x500name.getRDNs(objectId)) != null && rdns.length > 0) {
            return IETFUtils.valueToString((ASN1Encodable)rdns[0].getFirst().getValue());
        }
        return null;
    }

    public static String getElement(RDN[] rdns, ASN1ObjectIdentifier objectId) {
        for (RDN rdn : rdns) {
            if (!rdn.getFirst().getType().equals((ASN1Primitive)objectId)) continue;
            return ((ASN1String)rdn.getFirst().getValue()).getString();
        }
        return null;
    }

    @Generated
    private CertificateHandler() {
    }
}

