/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import lombok.Generated;
import net.maritimeconnectivity.pki.PKIConfiguration;
import net.maritimeconnectivity.pki.exception.PKIRuntimeException;
import net.maritimeconnectivity.pki.pkcs11.P11PKIConfiguration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeystoreHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeystoreHandler.class);
    private final PKIConfiguration pkiConfiguration;

    public KeystoreHandler(PKIConfiguration pkiConfiguration) {
        this.pkiConfiguration = pkiConfiguration;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public KeyStore.PrivateKeyEntry getSigningCertEntry(String alias) {
        KeyStore.PrivateKeyEntry privateKeyEntry;
        KeyStore keyStore;
        PKIConfiguration pKIConfiguration = this.pkiConfiguration;
        if (pKIConfiguration instanceof P11PKIConfiguration) {
            P11PKIConfiguration p11PKIConfiguration = (P11PKIConfiguration)pKIConfiguration;
            try {
                keyStore = KeyStore.getInstance("PKCS11", p11PKIConfiguration.getProvider());
                keyStore.load(null, p11PKIConfiguration.getPkcs11Pin());
                return (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, null);
            }
            catch (KeyStoreException e) {
                log.error("Could not create PKCS#11 keystore");
                p11PKIConfiguration.providerLogout();
                throw new PKIRuntimeException(e.getMessage(), e);
            }
            catch (IOException | NoSuchAlgorithmException | CertificateException e) {
                log.error("Could not open PKCS#11 keystore");
                p11PKIConfiguration.providerLogout();
                throw new PKIRuntimeException(e.getMessage(), e);
            }
            catch (UnrecoverableEntryException e) {
                log.error("Could not get CA entry from PKCS#11 keystore");
                p11PKIConfiguration.providerLogout();
                throw new PKIRuntimeException(e.getMessage(), e);
            }
        }
        FileInputStream is = new FileInputStream(this.pkiConfiguration.getSubCaKeystorePath());
        try {
            keyStore = KeyStore.getInstance("jks");
            keyStore.load(is, this.pkiConfiguration.getSubCaKeystorePassword().toCharArray());
            KeyStore.PasswordProtection protectionParameter = new KeyStore.PasswordProtection(this.pkiConfiguration.getSubCaKeyPassword().toCharArray());
            privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(alias, protectionParameter);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                log.error("Could not open CA keystore", (Throwable)e);
                throw new PKIRuntimeException(e.getMessage(), e);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableEntryException | CertificateException e) {
                log.error("Could not get CA entry", (Throwable)e);
                throw new PKIRuntimeException(e.getMessage(), e);
            }
        }
        is.close();
        return privateKeyEntry;
    }

    public Certificate getMCPCertificate(String alias) {
        Certificate certificate;
        log.debug(this.pkiConfiguration.getTruststorePath());
        FileInputStream is = new FileInputStream(this.pkiConfiguration.getTruststorePath());
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            keyStore.load(is, this.pkiConfiguration.getTruststorePassword().toCharArray());
            certificate = keyStore.getCertificate(alias);
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                log.error("Could not open truststore", (Throwable)e);
                throw new PKIRuntimeException(e.getMessage(), e);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                log.error("Could not load CA certificate", (Throwable)e);
                throw new PKIRuntimeException(e.getMessage(), e);
            }
        }
        is.close();
        return certificate;
    }

    public KeyStore getTrustStore() {
        KeyStore keyStore;
        FileInputStream is = new FileInputStream(this.pkiConfiguration.getTruststorePath());
        try {
            KeyStore keyStore2 = KeyStore.getInstance("jks");
            keyStore2.load(is, this.pkiConfiguration.getTruststorePassword().toCharArray());
            keyStore = keyStore2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    is.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                log.error("Could not open truststore", (Throwable)e);
                throw new PKIRuntimeException(e.getMessage(), e);
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                log.error("Could not load truststore", (Throwable)e);
                throw new PKIRuntimeException(e.getMessage(), e);
            }
        }
        is.close();
        return keyStore;
    }

    public PublicKey getPubKey(String alias) {
        Certificate cert = this.getMCPCertificate(alias);
        return cert.getPublicKey();
    }
}

