/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CRLReason;
import java.security.cert.X509Certificate;
import java.util.Optional;
import lombok.Generated;
import net.maritimeconnectivity.pki.CertificateHandler;
import net.maritimeconnectivity.pki.RevocationInfo;
import net.maritimeconnectivity.pki.ocsp.OCSPClient;
import net.maritimeconnectivity.pki.ocsp.OCSPValidationException;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.cert.ocsp.RevokedStatus;

public class OCSPVerifier {
    public static RevocationInfo verifyCertificateOCSP(X509Certificate cert, KeyStore trustStore) throws KeyStoreException, OCSPValidationException {
        X500Name x500name = new X500Name(cert.getIssuerX500Principal().getName());
        String issuerAlias = CertificateHandler.getElement(x500name, BCStyle.UID);
        X509Certificate issuerCert = (X509Certificate)trustStore.getCertificate(issuerAlias);
        return OCSPVerifier.verifyCertificateOCSP(cert, issuerCert);
    }

    public static RevocationInfo verifyCertificateOCSP(X509Certificate cert, X509Certificate issuerCert) throws OCSPValidationException {
        OCSPClient ocspClient = new OCSPClient(issuerCert, cert);
        RevocationInfo info = new RevocationInfo();
        if (ocspClient.checkOCSP()) {
            info.setStatus(ocspClient.getCertificateStatus());
        } else {
            info.setStatus(ocspClient.getCertificateStatus());
            Optional<RevokedStatus> revokedStatus = ocspClient.getRevokedStatus();
            if (revokedStatus.isPresent()) {
                RevokedStatus rs = revokedStatus.get();
                info.setRevokeReason(CRLReason.values()[rs.getRevocationReason()]);
                info.setRevokedAt(rs.getRevocationTime());
            }
        }
        return info;
    }

    @Generated
    private OCSPVerifier() {
    }
}

