/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.security.AuthProvider;
import java.security.KeyStore;
import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import lombok.Generated;
import net.maritimeconnectivity.pki.CertificateHandler;
import net.maritimeconnectivity.pki.PKIConfiguration;
import net.maritimeconnectivity.pki.RevocationInfo;
import net.maritimeconnectivity.pki.exception.PKIRuntimeException;
import net.maritimeconnectivity.pki.pkcs11.P11PKIConfiguration;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.ocsp.OCSPResponse;
import org.bouncycastle.asn1.ocsp.OCSPResponseStatus;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CRLHolder;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v2CRLBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CRLConverter;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.BasicOCSPRespBuilder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.OCSPRespBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Revocation {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Revocation.class);

    public static int getCRLReasonFromString(String certReason) {
        return switch (certReason) {
            case "keycompromise" -> 1;
            case "cacompromise" -> 2;
            case "affiliationchanged" -> 3;
            case "superseded" -> 4;
            case "cessationofoperation" -> 5;
            case "certificatehold" -> 6;
            case "removefromcrl" -> 8;
            case "privilegewithdrawn" -> 9;
            case "aacompromise" -> 10;
            default -> 0;
        };
    }

    public static X509CRL generateCRL(List<RevocationInfo> revokedCerts, KeyStore.PrivateKeyEntry keyEntry, PKIConfiguration pkiConfiguration) {
        ContentSigner signer;
        String signCertX500Name;
        Date now = Date.from(Instant.now());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(now);
        cal.add(5, 7);
        try {
            signCertX500Name = new JcaX509CertificateHolder((X509Certificate)keyEntry.getCertificate()).getSubject().toString();
        }
        catch (CertificateEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(new X500Name(signCertX500Name), now);
        crlBuilder.setNextUpdate(cal.getTime());
        for (RevocationInfo cert : revokedCerts) {
            crlBuilder.addCRLEntry(cert.getSerialNumber(), cert.getRevokedAt(), cert.getRevokeReason().ordinal());
        }
        JcaContentSignerBuilder signBuilder = new JcaContentSignerBuilder("SHA384withECDSA");
        if (pkiConfiguration instanceof P11PKIConfiguration) {
            P11PKIConfiguration p11PKIConfiguration = (P11PKIConfiguration)pkiConfiguration;
            signBuilder.setProvider((Provider)p11PKIConfiguration.getProvider());
        } else {
            signBuilder.setProvider("BC");
        }
        try {
            signer = signBuilder.build(keyEntry.getPrivateKey());
        }
        catch (OperatorCreationException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
            return null;
        }
        X509CRLHolder cRLHolder = crlBuilder.build(signer);
        JcaX509CRLConverter converter = new JcaX509CRLConverter();
        converter.setProvider("BC");
        X509CRL crl = null;
        try {
            crl = converter.getCRL(cRLHolder);
        }
        catch (CRLException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return crl;
    }

    public static void generateRootCACRL(String signName, List<RevocationInfo> revokedCerts, KeyStore.PrivateKeyEntry keyEntry, String outputCaCrlPath, AuthProvider pkcs11Provider) {
        String pemCrl;
        X509CRL crl;
        ContentSigner signer;
        Date now = Date.from(Instant.now());
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.setTime(now);
        cal.add(1, 1);
        X509v2CRLBuilder crlBuilder = new X509v2CRLBuilder(new X500Name(signName), now);
        crlBuilder.setNextUpdate(cal.getTime());
        if (revokedCerts != null) {
            for (RevocationInfo cert : revokedCerts) {
                crlBuilder.addCRLEntry(cert.getSerialNumber(), cert.getRevokedAt(), cert.getRevokeReason().ordinal());
            }
        }
        JcaContentSignerBuilder signBuilder = new JcaContentSignerBuilder("SHA384withECDSA");
        if (pkcs11Provider != null) {
            signBuilder.setProvider((Provider)pkcs11Provider);
        } else {
            signBuilder.setProvider("BC");
        }
        try {
            signer = signBuilder.build(keyEntry.getPrivateKey());
        }
        catch (OperatorCreationException e1) {
            log.error(e1.getMessage(), (Throwable)e1);
            return;
        }
        X509CRLHolder cRLHolder = crlBuilder.build(signer);
        JcaX509CRLConverter converter = new JcaX509CRLConverter();
        converter.setProvider("BC");
        try {
            crl = converter.getCRL(cRLHolder);
        }
        catch (CRLException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
        try {
            pemCrl = CertificateHandler.getPemFromEncoded("X509 CRL", crl.getEncoded());
        }
        catch (IOException | CRLException e) {
            log.error("unable to generate Root CA CRL", (Throwable)e);
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputCaCrlPath));){
            writer.write(pemCrl);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static OCSPResp handleOCSP(OCSPReq request, PublicKey caPublicKey, KeyStore.PrivateKeyEntry signingCA, Map<CertificateID, CertificateStatus> certificateStatusMap, PKIConfiguration pkiConfiguration) {
        OCSPResp ocspResp;
        BasicOCSPRespBuilder respBuilder;
        if (request == null) {
            OCSPResponse response = new OCSPResponse(new OCSPResponseStatus(1), null);
            return new OCSPResp(response);
        }
        try {
            respBuilder = Revocation.initOCSPRespBuilder(request, caPublicKey);
        }
        catch (OCSPException | OperatorCreationException e) {
            log.error("Could not build OCSP responder", e);
            OCSPResponse response = new OCSPResponse(new OCSPResponseStatus(2), null);
            return new OCSPResp(response);
        }
        certificateStatusMap.forEach((arg_0, arg_1) -> ((BasicOCSPRespBuilder)respBuilder).addResponse(arg_0, arg_1));
        P11PKIConfiguration p11PKIConfiguration = null;
        if (pkiConfiguration instanceof P11PKIConfiguration) {
            P11PKIConfiguration tmp;
            p11PKIConfiguration = tmp = (P11PKIConfiguration)pkiConfiguration;
            p11PKIConfiguration.providerLogin();
        }
        try {
            ocspResp = Revocation.generateOCSPResponse(respBuilder, signingCA, p11PKIConfiguration);
        }
        catch (IOException | CertificateEncodingException | OCSPException | OperatorCreationException e) {
            log.error("Could not generate OCSP response", e);
            OCSPResponse response = new OCSPResponse(new OCSPResponseStatus(2), null);
            if (p11PKIConfiguration != null) {
                p11PKIConfiguration.providerLogout();
            }
            return new OCSPResp(response);
        }
        if (p11PKIConfiguration != null) {
            p11PKIConfiguration.providerLogout();
        }
        return ocspResp;
    }

    public static BasicOCSPRespBuilder initOCSPRespBuilder(OCSPReq request, PublicKey publicKey) throws OCSPException, OperatorCreationException {
        SubjectPublicKeyInfo keyinfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        BasicOCSPRespBuilder respBuilder = new BasicOCSPRespBuilder(keyinfo, new JcaDigestCalculatorProviderBuilder().setProvider("BC").build().get(CertificateID.HASH_SHA1));
        Extension ext = request.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (ext != null) {
            respBuilder.setResponseExtensions(new Extensions(new Extension[]{ext}));
        }
        return respBuilder;
    }

    public static OCSPResp generateOCSPResponse(BasicOCSPRespBuilder respBuilder, KeyStore.PrivateKeyEntry signingCert, P11PKIConfiguration p11PKIConfiguration) throws OCSPException, IOException, OperatorCreationException, CertificateEncodingException {
        try {
            JcaContentSignerBuilder signBuilder = new JcaContentSignerBuilder("SHA384withECDSA");
            if (p11PKIConfiguration != null) {
                p11PKIConfiguration.providerLogin();
                signBuilder.setProvider((Provider)p11PKIConfiguration.getProvider());
            } else {
                signBuilder.setProvider("BC");
            }
            ContentSigner contentSigner = signBuilder.build(signingCert.getPrivateKey());
            BasicOCSPResp basicResp = respBuilder.build(contentSigner, new X509CertificateHolder[]{new X509CertificateHolder(signingCert.getCertificate().getEncoded())}, Date.from(Instant.now()));
            int response = 0;
            OCSPResp ocspResp = new OCSPRespBuilder().build(response, (Object)basicResp);
            if (p11PKIConfiguration != null) {
                p11PKIConfiguration.providerLogout();
            }
            return ocspResp;
        }
        catch (CertificateEncodingException | OCSPException | OperatorCreationException e) {
            if (p11PKIConfiguration != null) {
                p11PKIConfiguration.providerLogout();
            }
            throw e;
        }
    }

    @Generated
    private Revocation() {
    }
}

