/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki.ocsp;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import net.maritimeconnectivity.pki.ocsp.CertStatus;
import net.maritimeconnectivity.pki.ocsp.OCSPValidationException;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.ExtendedKeyUsage;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.KeyPurposeId;
import org.bouncycastle.cert.CertException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.jcajce.JcaCertificateID;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;

public class OCSPClient {
    private byte[] sentNonce;
    private final X509Certificate issuer;
    private final X509Certificate certificate;
    private final URL url;
    private RevokedStatus revokedStatus = null;

    public OCSPClient(X509Certificate issuer, X509Certificate certificate) {
        this.issuer = issuer;
        this.certificate = certificate;
        this.url = OCSPClient.getOcspUrlFromCertificate(certificate);
    }

    private OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws CertificateEncodingException, OperatorCreationException, OCSPException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        OCSPReqBuilder gen = new OCSPReqBuilder();
        gen.addRequest((CertificateID)new JcaCertificateID(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build().get(CertificateID.HASH_SHA1), issuerCert, serialNumber));
        BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
        Extension ext = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, true, (ASN1OctetString)new DEROctetString(nonce.toByteArray()));
        gen.setRequestExtensions(new Extensions(new Extension[]{ext}));
        this.sentNonce = ext.getExtnId().getEncoded();
        return gen.build();
    }

    public static URL getOcspUrlFromCertificate(X509Certificate certificate) {
        byte[] octetBytes = certificate.getExtensionValue(Extension.authorityInfoAccess.getId());
        URL url = null;
        if (null != octetBytes) {
            try {
                byte[] encoded = JcaX509ExtensionUtils.parseExtensionValue((byte[])octetBytes).getEncoded();
                ASN1Sequence seq = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])encoded));
                AuthorityInformationAccess access = AuthorityInformationAccess.getInstance((Object)seq);
                for (AccessDescription accessDescription : access.getAccessDescriptions()) {
                    if (!accessDescription.getAccessMethod().equals((ASN1Primitive)AccessDescription.id_ad_ocsp)) continue;
                    url = URI.create(accessDescription.getAccessLocation().getName().toString()).toURL();
                    break;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return url;
    }

    public Optional<RevokedStatus> getRevokedStatus() {
        return Optional.ofNullable(this.revokedStatus);
    }

    public CertStatus getCertificateStatus() throws OCSPValidationException {
        try {
            SingleResp[] responses;
            if (null == this.url) {
                throw new OCSPValidationException("Certificate not validated by OCSP");
            }
            byte[] encodedOcspRequest = this.generateOCSPRequest(this.issuer, this.certificate.getSerialNumber()).getEncoded();
            HttpURLConnection httpConnection = (HttpURLConnection)this.url.openConnection();
            httpConnection.setRequestProperty("Content-Type", "application/ocsp-request");
            httpConnection.setRequestProperty("Accept", "application/ocsp-response");
            httpConnection.setDoOutput(true);
            try (DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(httpConnection.getOutputStream()));){
                dataOut.write(encodedOcspRequest);
                dataOut.flush();
            }
            InputStream in = (InputStream)httpConnection.getContent();
            if (httpConnection.getResponseCode() != 200) {
                throw new OCSPValidationException("Received HTTP code != 200 [" + httpConnection.getResponseCode() + "]");
            }
            OCSPResp ocspResponse = new OCSPResp(in);
            BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
            byte[] receivedNonce = basicResponse.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce).getExtnId().getEncoded();
            if (!Arrays.equals(receivedNonce, this.sentNonce)) {
                throw new OCSPValidationException("Nonce in ocsp response does not match nonce of ocsp request");
            }
            X509CertificateHolder certHolder = basicResponse.getCerts()[0];
            if (!basicResponse.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(this.issuer))) {
                if (!certHolder.isValidOn(Date.from(Instant.now()))) {
                    throw new OCSPValidationException("Certificate is not valid today!");
                }
                if (!ExtendedKeyUsage.fromExtensions((Extensions)certHolder.getExtensions()).hasKeyPurposeId(KeyPurposeId.id_kp_OCSPSigning)) {
                    throw new OCSPValidationException("Certificate does not contain required extension (id_kp_OCSPSigning)");
                }
                if (!certHolder.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(this.issuer))) {
                    throw new OCSPValidationException("Certificate is not signed by the same issuer");
                }
                if (!basicResponse.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(certHolder))) {
                    throw new OCSPValidationException("Could not validate OCSP response!");
                }
            } else if (!certHolder.isValidOn(Date.from(Instant.now()))) {
                throw new OCSPValidationException("Certificate is not valid today!");
            }
            if ((responses = basicResponse.getResponses())[0].getCertID().getSerialNumber().equals(this.certificate.getSerialNumber())) {
                CertificateStatus status = responses[0].getCertStatus();
                if (status == CertificateStatus.GOOD) {
                    return CertStatus.GOOD;
                }
                if (status instanceof RevokedStatus) {
                    RevokedStatus revStatus;
                    this.revokedStatus = revStatus = (RevokedStatus)status;
                    return CertStatus.REVOKED;
                }
                return CertStatus.UNKNOWN;
            }
            throw new OCSPValidationException("Serial number of certificate in response ocsp does not match certificate serial number");
        }
        catch (IOException | CertificateException | CertException | OCSPException | OperatorCreationException ex) {
            throw new OCSPValidationException("Unable to perform validation through OCSP (" + this.certificate.getSubjectX500Principal().getName() + ")", ex);
        }
    }

    public boolean checkOCSP() {
        try {
            return this.getCertificateStatus() == CertStatus.GOOD;
        }
        catch (OCSPValidationException ex) {
            return false;
        }
    }
}

