/*
 * Decompiled with CFR 0.152.
 */
package net.maritimeconnectivity.pki.pkcs11;

import java.io.Console;
import java.security.AuthProvider;
import java.security.Provider;
import java.security.Security;
import javax.security.auth.login.LoginException;
import lombok.Generated;
import lombok.NonNull;
import net.maritimeconnectivity.pki.PKIConfiguration;
import net.maritimeconnectivity.pki.exception.PKIRuntimeException;
import net.maritimeconnectivity.pki.pkcs11.PasswordHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P11PKIConfiguration
extends PKIConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(P11PKIConfiguration.class);
    private final String pkcs11ProviderName;
    private final AuthProvider provider;
    private final char[] pkcs11Pin;
    private final PasswordHandler passwordHandler;

    public P11PKIConfiguration(@NonNull String rootCAAlias, String pkcs11ConfigPath, String pkcs11Pin) {
        this(rootCAAlias, pkcs11ConfigPath, pkcs11Pin == null ? null : pkcs11Pin.toCharArray());
        if (rootCAAlias == null) {
            throw new NullPointerException("rootCAAlias is marked non-null but is null");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public P11PKIConfiguration(@NonNull String rootCAAlias, String pkcs11ConfigPath, char[] pkcs11Pin) {
        super(rootCAAlias);
        if (rootCAAlias == null) {
            throw new NullPointerException("rootCAAlias is marked non-null but is null");
        }
        Provider p = Security.getProvider("SunPKCS11");
        p = p.configure(pkcs11ConfigPath);
        AuthProvider authProvider = (AuthProvider)p;
        Security.addProvider(authProvider);
        this.provider = authProvider;
        this.pkcs11ProviderName = authProvider.getName();
        if (pkcs11Pin == null) {
            Console console = System.console();
            if (console == null) throw new PKIRuntimeException("Could not get a system console");
            log.error("Please input HSM slot pin: ");
            this.pkcs11Pin = console.readPassword();
            console.flush();
        } else {
            this.pkcs11Pin = pkcs11Pin;
        }
        this.passwordHandler = new PasswordHandler(this.pkcs11Pin);
    }

    public void providerLogin() {
        try {
            this.provider.login(null, this.passwordHandler);
        }
        catch (LoginException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
    }

    public void providerLogout() {
        try {
            this.provider.logout();
        }
        catch (LoginException e) {
            throw new PKIRuntimeException(e.getMessage(), e);
        }
    }

    @Generated
    public String getPkcs11ProviderName() {
        return this.pkcs11ProviderName;
    }

    @Generated
    public AuthProvider getProvider() {
        return this.provider;
    }

    @Generated
    public char[] getPkcs11Pin() {
        return this.pkcs11Pin;
    }
}

