/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.json.parser;

import java.io.IOException;
import java.io.Reader;
import net.markenwerk.utils.json.parser.JsonSource;

public final class ReaderJsonSource
implements JsonSource {
    private static final int MINIMUM_BUFFER_SIZE = 128;
    private static final int DEFAULT_BUFFER_SIZE = 512;
    private final Reader reader;
    private final char[] buffer;
    private int position;
    private int end;
    private int line = 1;
    private int column = 1;
    private boolean firstCharacterRead;
    private int lastNewLinePosition;

    public ReaderJsonSource(Reader reader) {
        this(reader, 512);
    }

    public ReaderJsonSource(Reader reader, int size) {
        if (null == reader) {
            throw new IllegalArgumentException("The given reader is null");
        }
        if (size < 128) {
            throw new IllegalArgumentException("The given size is too small: " + size);
        }
        this.reader = reader;
        this.buffer = new char[size];
    }

    @Override
    public int getAvailable() {
        return this.end - this.position;
    }

    @Override
    public int makeAvailable() throws IOException {
        int available = this.getAvailable();
        if (0 != available) {
            return available;
        }
        this.fillBuffer(1);
        return this.getAvailable();
    }

    @Override
    public boolean makeAvailable(int minimum) throws IOException {
        return minimum <= this.end - this.position || this.fillBuffer(minimum);
    }

    private boolean fillBuffer(int minimum) throws IOException {
        if (0 != this.position && 0 != this.end) {
            System.arraycopy(this.buffer, this.position, this.buffer, 0, this.getAvailable());
            this.column += this.position - this.lastNewLinePosition;
            this.lastNewLinePosition = 0;
            this.end -= this.position;
        }
        this.position = 0;
        while (this.getAvailable() < minimum) {
            int read = this.reader.read(this.buffer, this.end, this.buffer.length - this.end);
            if (-1 == read) {
                return false;
            }
            this.end += read;
        }
        if (!this.firstCharacterRead && this.end >= 1) {
            if (this.buffer[0] == '\ufeff') {
                ++this.position;
            }
            this.firstCharacterRead = true;
        }
        return true;
    }

    @Override
    public char nextCharacter() {
        char result;
        if ('\n' == (result = this.buffer[this.position++])) {
            this.lastNewLinePosition = this.position;
            this.column = 1;
            ++this.line;
        }
        return result;
    }

    @Override
    public char peekCharacter(int offset) {
        return this.buffer[this.position + offset];
    }

    @Override
    public String nextString(int length) {
        for (int i = 0; i < length; ++i) {
            this.nextCharacter();
        }
        return new String(this.buffer, this.position - length, length);
    }

    @Override
    public void appendNextString(StringBuilder builder, int length) {
        for (int i = 0; i < length; ++i) {
            builder.append(this.nextCharacter());
        }
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getColumn() {
        return this.column + (this.position - this.lastNewLinePosition);
    }

    @Override
    public String getPast(int maximum) {
        if (0 == this.position) {
            return "";
        }
        int stillAvailable = Math.min(this.position, maximum);
        return new String(this.buffer, this.position - stillAvailable, stillAvailable);
    }

    @Override
    public String getFuture(int maximum) {
        int alreadyAvailable = Math.min(this.end - this.position, maximum);
        return new String(this.buffer, this.position, alreadyAvailable);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

