/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.lrucache;

import java.util.LinkedHashMap;
import java.util.Map;
import net.markenwerk.utils.lrucache.LruCacheListener;

public final class LruCache<Key, Value>
extends LinkedHashMap<Key, Value> {
    private static final long serialVersionUID = 580280319605735218L;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int cacheSize;
    private final LruCacheListener<Key, Value> listener;

    public LruCache(int cacheSize) throws IllegalArgumentException {
        this(cacheSize, null);
    }

    public LruCache(int cacheSize, LruCacheListener<Key, Value> listener) throws IllegalArgumentException {
        super(cacheSize, 0.75f, true);
        if (cacheSize < 0) {
            throw new IllegalArgumentException("cacheSize is negative");
        }
        this.cacheSize = cacheSize;
        this.listener = listener;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<Key, Value> eldest) {
        if (this.size() > this.cacheSize) {
            if (null != this.listener) {
                this.listener.onEvicted(eldest);
            }
            return true;
        }
        return false;
    }
}

