/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.mail.dkim;

import com.sun.mail.smtp.SMTPMessage;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeUtility;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import net.markenwerk.utils.data.fetcher.BufferedDataFetcher;
import net.markenwerk.utils.mail.dkim.DkimSigner;

public class DkimMessage
extends SMTPMessage {
    private static byte[] NL = new byte[]{13, 10};
    private DkimSigner signer;
    private String encodedBody;

    public DkimMessage(MimeMessage message, DkimSigner signer) throws MessagingException {
        super(message);
        this.signer = signer;
    }

    public void writeTo(OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        if (!this.saved) {
            this.saveChanges();
        }
        ByteArrayOutputStream bodyBuffer = new ByteArrayOutputStream();
        if (this.modified) {
            OutputStream encodingOutputStream = MimeUtility.encode((OutputStream)bodyBuffer, (String)this.getEncoding());
            this.getDataHandler().writeTo(encodingOutputStream);
            encodingOutputStream.flush();
            encodingOutputStream.close();
        } else if (null == this.content) {
            new BufferedDataFetcher().copy(this.getContentStream(), (OutputStream)bodyBuffer, true, false);
            bodyBuffer.flush();
            bodyBuffer.close();
        } else {
            bodyBuffer.write(this.content);
            bodyBuffer.flush();
            bodyBuffer.close();
        }
        this.encodedBody = bodyBuffer.toString();
        String signatureHeaderLine = this.signer.sign(this);
        DkimMessage.writeln(os, signatureHeaderLine);
        Enumeration headerLines = this.getNonMatchingHeaderLines(ignoreList);
        while (headerLines.hasMoreElements()) {
            DkimMessage.writeln(os, (String)headerLines.nextElement());
        }
        DkimMessage.writeln(os);
        os.flush();
        os.write(bodyBuffer.toByteArray());
        os.flush();
    }

    protected String getEncodedBody() {
        return this.encodedBody;
    }

    public void setAllow8bitMIME(boolean allow) {
        super.setAllow8bitMIME(false);
    }

    private static void writeln(OutputStream out) throws IOException {
        out.write(NL);
    }

    private static void writeln(OutputStream out, String string) throws IOException {
        byte[] bytes = DkimMessage.getBytes(string);
        out.write(bytes);
        out.write(NL);
    }

    private static byte[] getBytes(String string) {
        char[] chars = string.toCharArray();
        byte[] bytes = new byte[chars.length];
        int n = chars.length;
        for (int i = 0; i < n; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }
}

