/*
 * Decompiled with CFR 0.152.
 */
package net.markenwerk.utils.mail.dkim;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import net.i2p.crypto.eddsa.EdDSASecurityProvider;
import net.markenwerk.utils.mail.dkim.SigningAlgorithm;

public enum KeyPairType {
    RSA("rsa", "RSA", SigningAlgorithm.SHA256_WITH_RSA, new SigningAlgorithm[]{SigningAlgorithm.SHA256_WITH_RSA, SigningAlgorithm.SHA1_WITH_RSA}){

        @Override
        protected void initialize() {
        }
    }
    ,
    ED25519("ed25519", "EdDSA", SigningAlgorithm.SHA256_WITH_ED25519, new SigningAlgorithm[]{SigningAlgorithm.SHA256_WITH_ED25519}){
        private boolean initailized;

        @Override
        protected void initialize() {
            if (!this.initailized) {
                Security.addProvider((Provider)new EdDSASecurityProvider());
                this.initailized = true;
            }
        }
    };

    private final String dkimNotation;
    private final String javaNotation;
    private final SigningAlgorithm defaultSigningAlgorithm;
    private final List<SigningAlgorithm> supportedSigningAlgorithms;

    private KeyPairType(String dkimNotation, String javaNotation, SigningAlgorithm defaultSigningAlgorithm, SigningAlgorithm[] supportedSigningAlgorithms) {
        this.dkimNotation = dkimNotation;
        this.javaNotation = javaNotation;
        this.defaultSigningAlgorithm = defaultSigningAlgorithm;
        this.supportedSigningAlgorithms = Arrays.asList(supportedSigningAlgorithms);
    }

    public String getDkimNotation() {
        return this.dkimNotation;
    }

    public String getJavaNotation() {
        return this.javaNotation;
    }

    public SigningAlgorithm getDefaultSigningAlgorithm() {
        return this.defaultSigningAlgorithm;
    }

    public boolean supportsSigningAlgorithm(SigningAlgorithm signingAlgorithm) {
        return this.supportedSigningAlgorithms.contains((Object)signingAlgorithm);
    }

    protected abstract void initialize();
}

