/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.common.base.Joiner;
import com.googlecode.totallylazy.Function1;
import com.googlecode.totallylazy.Option;
import com.googlecode.totallylazy.Sequences;
import com.googlecode.totallylazy.predicates.LogicalPredicate;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.masterthought.cucumber.json.DocString;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Row;
import net.masterthought.cucumber.util.Status;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;

public class Step {
    private String name;
    private String keyword;
    private String line;
    private Result result;
    private Row[] rows;
    private Match match;
    private Object[] embeddings;
    private String[] output;
    private DocString doc_string;

    public DocString getDocString() {
        return this.doc_string;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public String getOutput() {
        List outputList = Sequences.sequence((Object[])((Object[])Option.option((Object)this.output).getOrElse((Object)new String[0]))).realise().toList();
        return Joiner.on((String)"").skipNulls().join((Iterable)outputList);
    }

    public Match getMatch() {
        return this.match;
    }

    public Object[] getEmbeddings() {
        return this.embeddings;
    }

    public boolean hasRows() {
        boolean result = false;
        if (this.rows != null && this.rows.length > 0) {
            result = true;
        }
        return result;
    }

    public boolean hasDocString() {
        return this.doc_string != null && this.doc_string.hasValue();
    }

    public Status getStatus() {
        if (this.result == null) {
            System.out.println("[WARNING] Line " + this.line + " : " + "Step is missing Result: " + this.keyword + " : " + this.name);
            return Status.MISSING;
        }
        return Status.valueOf(this.result.getStatus().toUpperCase());
    }

    public Long getDuration() {
        if (this.result == null) {
            return 1L;
        }
        return this.result.getDuration();
    }

    public String getDataTableClass() {
        String content = "";
        Status status = this.getStatus();
        content = status == Status.FAILED || status == Status.PASSED || status == Status.SKIPPED ? status.getName() : "";
        return content;
    }

    public String getRawName() {
        return this.name;
    }

    public String getName() {
        String content = "";
        Status status = this.getStatus();
        if (status == Status.FAILED) {
            String errorMessage = this.result.getErrorMessage();
            if (status == Status.SKIPPED) {
                errorMessage = "Mode: Skipped causes Failure<br/><span class=\"skipped\">This step was skipped</span>";
            }
            if (status == Status.UNDEFINED) {
                errorMessage = "Mode: Not Implemented causes Failure<br/><span class=\"undefined\">This step is not yet implemented</span>";
            }
            content = this.getStatusDetails(status, errorMessage);
        } else if (status == Status.MISSING) {
            String errorMessage = "<span class=\"missing\">Result was missing for this step</span>";
            content = this.getStatusDetails(status, errorMessage);
        } else {
            content = this.getStatusDetails(status, null);
        }
        return content;
    }

    private String getStatusDetails(Status status, String errorMessage) {
        StringBuilder sb = new StringBuilder();
        sb.append(status.toHtmlClass());
        sb.append("<span class=\"step-keyword\">").append(this.keyword).append(" </span>");
        sb.append("<span class=\"step-name\">").append(StringEscapeUtils.escapeHtml((String)this.name)).append("</span>");
        sb.append("<span class=\"step-duration\">");
        if (status != Status.MISSING) {
            sb.append(Util.formatDuration(this.result.getDuration()));
        }
        sb.append("</span>");
        if (status == Status.FAILED || status == Status.MISSING) {
            sb.append("<div class=\"step-error-message\"><pre class=\"step-error-message-content\">").append(this.formatError(errorMessage)).append("</pre></div>");
        }
        sb.append("</div>");
        sb.append(this.getImageTags());
        return sb.toString();
    }

    public String getDocStringOrNothing() {
        if (!this.hasDocString()) {
            return "";
        }
        return this.getStatus().toHtmlClass() + "<div class=\"doc-string\">" + this.getDocString().getEscapedValue() + "</div></div>";
    }

    private String formatError(String errorMessage) {
        String result = errorMessage;
        if (errorMessage != null && !errorMessage.isEmpty()) {
            result = errorMessage.replaceAll("\\\\n", "<br/>");
        }
        return result;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getImageTags() {
        if (this.noEmbeddedScreenshots()) {
            return "";
        }
        String links = "";
        int index = 1;
        for (Object image : this.embeddings) {
            if (image == null) continue;
            String mimeEncodedImage = Step.mimeEncodeEmbededImage(image);
            String imageId = UUID.nameUUIDFromBytes(mimeEncodedImage.getBytes()).toString();
            links = links + String.format("<a onclick=\"img=document.getElementById('%s'); img.style.display = (img.style.display == 'none' ? 'block' : 'none');return false\">Screenshot %s</a><a href=\"%s\" data-lightbox=\"image-1\" data-title=\"%s\"><img id=\"%s\"src=\"%s\" style='max-width: 250px;display:none;' alt=\"This is the title\"/></a></br>", imageId, index++, mimeEncodedImage, StringEscapeUtils.escapeHtml((String)this.name), imageId, mimeEncodedImage);
        }
        return links;
    }

    private boolean noEmbeddedScreenshots() {
        return this.getEmbeddings() == null;
    }

    public static String mimeEncodeEmbededImage(Object image) {
        return "data:image/png;base64," + ((Map)image).get("data");
    }

    public static String uuidForImage(Object image) {
        return UUID.nameUUIDFromBytes(Step.mimeEncodeEmbededImage(image).getBytes()).toString();
    }

    public static class predicates {
        public static LogicalPredicate<Step> hasStatus(final Status status) {
            return new LogicalPredicate<Step>(){

                public boolean matches(Step step) {
                    return step.getStatus().equals((Object)status);
                }
            };
        }

        public static Function1<Step, Status> status() {
            return new Function1<Step, Status>(){

                public Status call(Step step) throws Exception {
                    return step.getStatus();
                }
            };
        }
    }

    public static class functions {
        public static Function1<Step, Status> status() {
            return new Function1<Step, Status>(){

                public Status call(Step step) throws Exception {
                    return step.getStatus();
                }
            };
        }
    }
}

