/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.ArtifactProcessor;
import net.masterthought.cucumber.ConfigurationOptions;
import net.masterthought.cucumber.ReportInformation;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.generators.ErrorPage;
import net.masterthought.cucumber.generators.FeatureOverviewPage;
import net.masterthought.cucumber.generators.FeatureReportPage;
import net.masterthought.cucumber.generators.StepOverviewPage;
import net.masterthought.cucumber.generators.TagOverviewPage;
import net.masterthought.cucumber.generators.TagReportPage;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.util.UnzipUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.velocity.exception.VelocityException;

public class ReportBuilder {
    private ReportInformation reportInformation;
    private List<String> jsonFiles;
    private File reportDirectory;
    private String buildNumber;
    private String buildProject;
    private String pluginUrlPath;
    private boolean flashCharts;
    private boolean runWithJenkins;
    private boolean artifactsEnabled;
    private boolean highCharts;
    private boolean parsingError;
    private Map<String, String> customHeader;
    public static final String VERSION = "cucumber-reporting-0.3.0";
    private static boolean parallel = false;

    public ReportInformation getReportInformation() {
        return this.reportInformation;
    }

    public void setRi(ReportInformation ri) {
        this.reportInformation = ri;
    }

    public static boolean isParallel() {
        return parallel;
    }

    public static void setParallel(boolean p) {
        parallel = p;
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(File reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getBuildProject() {
        return this.buildProject;
    }

    public void setBuildProject(String buildProject) {
        this.buildProject = buildProject;
    }

    public String getPluginUrlPath() {
        return this.pluginUrlPath;
    }

    public void setPluginUrlPath(String pluginUrlPath) {
        this.pluginUrlPath = pluginUrlPath;
    }

    public boolean isRunWithJenkins() {
        return this.runWithJenkins;
    }

    public void setRunWithJenkins(boolean runWithJenkins) {
        this.runWithJenkins = runWithJenkins;
    }

    public boolean isParsingError() {
        return this.parsingError;
    }

    public void setParsingError(boolean parsingError) {
        this.parsingError = parsingError;
    }

    public Map<String, String> getCustomHeader() {
        return this.customHeader;
    }

    public void setCustomHeader(Map<String, String> customHeader) {
        this.customHeader = customHeader;
    }

    public boolean isFlashCharts() {
        return this.flashCharts;
    }

    public void setFlashCharts(boolean flashCharts) {
        this.flashCharts = flashCharts;
    }

    public boolean isHighCharts() {
        return this.highCharts;
    }

    public void setHighCharts(boolean highCharts) {
        this.highCharts = highCharts;
    }

    public List<String> getJsonFiles() {
        return this.jsonFiles;
    }

    public ReportBuilder(List<String> jsonReports, File reportDirectory, String pluginUrlPath, String buildNumber, String buildProject, boolean skippedFails, boolean pendingFails, boolean undefinedFails, boolean missingFails, boolean flashCharts, boolean runWithJenkins, boolean artifactsEnabled, String artifactConfig, boolean highCharts, boolean parallelTesting) throws IOException, VelocityException {
        try {
            this.reportDirectory = reportDirectory;
            this.buildNumber = buildNumber;
            this.buildProject = buildProject;
            this.pluginUrlPath = this.getPluginUrlPath(pluginUrlPath);
            this.flashCharts = flashCharts;
            this.runWithJenkins = runWithJenkins;
            this.artifactsEnabled = artifactsEnabled;
            this.highCharts = highCharts;
            parallel = parallelTesting;
            this.jsonFiles = jsonReports;
            ConfigurationOptions configuration = ConfigurationOptions.instance();
            configuration.setSkippedFailsBuild(skippedFails);
            configuration.setPendingFailsBuild(pendingFails);
            configuration.setUndefinedFailsBuild(undefinedFails);
            configuration.setMissingFailsBuild(missingFails);
            configuration.setArtifactsEnabled(artifactsEnabled);
            if (artifactsEnabled) {
                ArtifactProcessor artifactProcessor = new ArtifactProcessor(artifactConfig);
                configuration.setArtifactConfiguration(artifactProcessor.process());
            }
            ReportParser reportParser = new ReportParser(jsonReports);
            this.reportInformation = new ReportInformation(reportParser.getFeatures());
        }
        catch (Exception exception) {
            this.parsingError = true;
            this.generateErrorPage(exception);
        }
    }

    public boolean getBuildStatus() {
        return this.reportInformation.getTotalStepsFailed() == 0;
    }

    public void generateReports() throws IOException, VelocityException {
        block4: {
            try {
                this.copyResource("themes", "blue.zip");
                this.copyResource("charts", "js.zip");
                if (this.flashCharts) {
                    this.copyResource("charts", "flash_charts.zip");
                }
                if (this.artifactsEnabled) {
                    this.copyResource("charts", "codemirror.zip");
                }
                this.setJsonFilesInFeatures();
                new FeatureOverviewPage(this).generatePage();
                new FeatureReportPage(this).generatePage();
                new TagReportPage(this).generatePage();
                new TagOverviewPage(this).generatePage();
                new StepOverviewPage(this).generatePage();
            }
            catch (Exception exception) {
                if (this.parsingError) break block4;
                this.generateErrorPage(exception);
            }
        }
    }

    private void setJsonFilesInFeatures() {
        for (Map.Entry<String, List<Feature>> pairs : this.reportInformation.getFeatureMap().entrySet()) {
            List<Feature> featureList = pairs.getValue();
            for (Feature feature : featureList) {
                String jsonFile = pairs.getKey().split("/")[pairs.getKey().split("/").length - 1];
                feature.setJsonFile(jsonFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResource(String resourceLocation, String resourceName) throws IOException, URISyntaxException {
        File tmpResourcesArchive = File.createTempFile("temp", resourceName + ".zip");
        InputStream resourceArchiveInputStream = ReportBuilder.class.getResourceAsStream(resourceLocation + "/" + resourceName);
        if (resourceArchiveInputStream == null) {
            resourceArchiveInputStream = ReportBuilder.class.getResourceAsStream("/" + resourceLocation + "/" + resourceName);
        }
        FileOutputStream resourceArchiveOutputStream = new FileOutputStream(tmpResourcesArchive);
        try {
            IOUtils.copy((InputStream)resourceArchiveInputStream, (OutputStream)resourceArchiveOutputStream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)resourceArchiveInputStream);
            IOUtils.closeQuietly((OutputStream)resourceArchiveOutputStream);
        }
        UnzipUtils.unzipToFile(tmpResourcesArchive, this.reportDirectory);
        FileUtils.deleteQuietly((File)tmpResourcesArchive);
    }

    private String getPluginUrlPath(String path) {
        return path.isEmpty() ? "/" : path;
    }

    private void generateErrorPage(Exception exception) throws IOException {
        ErrorPage errorPage = new ErrorPage(this, exception);
        errorPage.generatePage();
        System.out.println(exception);
    }
}

