/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.StepObject;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.util.Util;

public class StepOverviewPage
extends AbstractPage {
    public StepOverviewPage(ReportBuilder reportBuilder) {
        super(reportBuilder, "stepOverview.vm");
    }

    @Override
    public void generatePage() throws IOException {
        super.generatePage();
        this.contextMap.put("steps", (Object)this.sortStepsByDate());
        int allOccurrences = 0;
        long allDurations = 0L;
        for (StepObject stepObject : this.reportInformation.getStepObject().values()) {
            allOccurrences += stepObject.getTotalOccurrences();
            allDurations += stepObject.getTotalDuration();
        }
        this.contextMap.put("all_occurrences", (Object)allOccurrences);
        this.contextMap.put("all_durations", (Object)allDurations);
        this.contextMap.put("all_formatted_durations", (Object)Util.formatDuration(allDurations));
        super.generateReport("step-overview.html");
    }

    private StepObject[] sortStepsByDate() {
        StepObject[] array = new StepObject[this.reportInformation.getStepObject().size()];
        Arrays.sort(this.reportInformation.getStepObject().values().toArray(array), new DurationCompator());
        return array;
    }

    private static class DurationCompator
    implements Comparator<StepObject> {
        private DurationCompator() {
        }

        @Override
        public int compare(StepObject o1, StepObject o2) {
            return Long.signum(o2.getTotalDuration() - o1.getTotalDuration());
        }
    }
}

