/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.googlecode.totallylazy.Sequence;
import com.googlecode.totallylazy.Sequences;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.ScenarioResults;
import net.masterthought.cucumber.json.support.StepResults;
import net.masterthought.cucumber.util.Status;
import net.masterthought.cucumber.util.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Feature {
    private final String id;
    private final String name;
    private final String uri;
    private final String description;
    private final String keyword;
    private final Element[] elements = new Element[0];
    private final Tag[] tags = new Tag[0];
    private StepResults stepResults;
    private ScenarioResults scenarioResults;
    private String jsonFile = "";

    public Feature() {
        this.id = null;
        this.name = null;
        this.uri = null;
        this.description = null;
        this.keyword = null;
    }

    public String getDeviceName() {
        String name = "";
        String[] splitedJsonFile = this.jsonFile.split("_");
        if (splitedJsonFile.length > 1) {
            name = splitedJsonFile[0].substring(0, splitedJsonFile[0].length() - 1);
        }
        return name;
    }

    public void setJsonFile(String json) {
        this.jsonFile = json;
    }

    public Sequence<Element> getElements() {
        return Sequences.sequence((Object[])this.elements).realise();
    }

    public String getFileName() {
        String[] splitedJsonFile;
        ArrayList<String> matches = new ArrayList<String>();
        for (String line : Splitter.onPattern((String)"/|\\\\").split((CharSequence)this.uri)) {
            String modified = line.replaceAll("\\)|\\(", "");
            modified = StringUtils.deleteWhitespace((String)modified).trim();
            matches.add(modified);
        }
        List lastElement = matches.subList(1, matches.size());
        matches = lastElement.isEmpty() ? matches : lastElement;
        String fileName = Joiner.on((String)"-").join(matches);
        if (ReportBuilder.isParallel() && !this.jsonFile.isEmpty() && (splitedJsonFile = this.jsonFile.split("_")).length > 1) {
            fileName = fileName + "-" + this.getDeviceName();
        }
        fileName = fileName + ".html";
        return fileName;
    }

    public String getUri() {
        return this.uri;
    }

    public boolean hasTags() {
        return Util.arrayNotEmpty(this.tags);
    }

    public boolean hasScenarios() {
        return !this.getElements().isEmpty();
    }

    public Sequence<String> getTagList() {
        return this.getTags().map(Tag.functions.getName());
    }

    public Sequence<Tag> getTags() {
        return Sequences.sequence((Object[])this.tags).realise();
    }

    public String getTagsList() {
        String result = "<div class=\"feature-tags\"></div>";
        if (Util.arrayNotEmpty(this.tags)) {
            List str = this.getTagList().toList();
            ArrayList<String> tagList = new ArrayList<String>();
            for (String s : str) {
                String link = s.replace("@", "").trim() + ".html";
                String ref = "<a href=\"" + link + "\">" + s + "</a>";
                tagList.add(ref);
            }
            result = "<div class=\"feature-tags\">" + StringUtils.join((Object[])tagList.toArray(), (String)",") + "</div>";
        }
        return result;
    }

    public Status getStatus() {
        Sequence results = this.getElements().map(Element.Functions.status());
        return results.contains((Object)Status.FAILED) ? Status.FAILED : Status.PASSED;
    }

    public String getName() {
        return Util.itemExists(this.name) ? this.getStatus().toHtmlClass() + "<div class=\"feature-line\"><span class=\"feature-keyword\">" + this.keyword + ":</span> " + this.name + "</div></div>" : "";
    }

    public String getRawName() {
        return Util.itemExists(this.name) ? StringEscapeUtils.escapeHtml((String)this.name) : "";
    }

    public String getRawStatus() {
        return this.getStatus().toString().toLowerCase();
    }

    public String getDescription() {
        String result = "";
        if (Util.itemExists(this.description)) {
            String content = this.description.replaceFirst("As an", "<span class=\"feature-role\">As an</span>");
            content = content.replaceFirst("I want to", "<span class=\"feature-action\">I want to</span>");
            content = content.replaceFirst("So that", "<span class=\"feature-value\">So that</span>");
            content = content.replaceAll("\n", "<br/>");
            result = "<div class=\"feature-description\">" + content + "</div>";
        }
        return result;
    }

    public int getNumberOfScenarios() {
        int result = 0;
        if (this.elements != null) {
            ArrayList<Element> elementList = new ArrayList<Element>();
            for (Element element : this.elements) {
                if (element.isBackground()) continue;
                elementList.add(element);
            }
            result = elementList.size();
        }
        return result;
    }

    public int getNumberOfSteps() {
        return this.stepResults.getNumberOfSteps();
    }

    public int getNumberOfPasses() {
        return this.stepResults.getNumberOfPasses();
    }

    public int getNumberOfFailures() {
        return this.stepResults.getNumberOfFailures();
    }

    public int getNumberOfPending() {
        return this.stepResults.getNumberOfPending();
    }

    public int getNumberOfSkipped() {
        return this.stepResults.getNumberOfSkipped();
    }

    public int getNumberOfMissing() {
        return this.stepResults.getNumberOfMissing();
    }

    public int getNumberOfUndefined() {
        return this.stepResults.getNumberOfUndefined();
    }

    public String getDurationOfSteps() {
        return this.stepResults.getTotalDurationAsString();
    }

    public int getNumberOfScenariosPassed() {
        return this.scenarioResults.getNumberOfScenariosPassed();
    }

    public int getNumberOfScenariosFailed() {
        return this.scenarioResults.getNumberOfScenariosFailed();
    }

    public void processSteps() {
        ArrayList<Step> allSteps = new ArrayList<Step>();
        StatusCounter stepsCounter = new StatusCounter();
        ArrayList<Element> passedScenarios = new ArrayList<Element>();
        ArrayList<Element> failedScenarios = new ArrayList<Element>();
        long totalDuration = 0L;
        if (this.elements != null) {
            for (Element element : this.elements) {
                this.calculateScenarioStats(passedScenarios, failedScenarios, element);
                if (!element.hasSteps()) continue;
                Sequence<Step> steps = element.getSteps();
                for (Step step : steps) {
                    allSteps.add(step);
                    stepsCounter.incrementFor(step.getStatus());
                    totalDuration += step.getDuration();
                }
            }
        }
        this.scenarioResults = new ScenarioResults(passedScenarios, failedScenarios);
        this.stepResults = new StepResults(allSteps, stepsCounter, totalDuration);
    }

    private void calculateScenarioStats(List<Element> passedScenarios, List<Element> failedScenarios, Element element) {
        if (!element.isBackground()) {
            if (element.getStatus() == Status.PASSED) {
                passedScenarios.add(element);
            } else if (element.getStatus() == Status.FAILED) {
                failedScenarios.add(element);
            }
        }
    }
}

