/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.List;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.util.Status;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.joda.time.format.PeriodFormatter;
import org.joda.time.format.PeriodFormatterBuilder;

public class Util {
    private static final PeriodFormatter TIME_FORMATTER = new PeriodFormatterBuilder().appendDays().appendSuffix("d").appendSeparator(" ").appendHours().appendSuffix("h").appendSeparator(" ").appendMinutes().appendSuffix("m").appendSeparator(" ").minimumPrintedDigits(2).appendSeconds().appendSuffix("s").appendSeparator(" ").minimumPrintedDigits(3).appendMillis().appendSuffix("ms").toFormatter();

    public static String readFileAsString(String filePath) throws IOException {
        return new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
    }

    public static boolean itemExists(String item) {
        return item != null && !item.isEmpty();
    }

    public static boolean arrayNotEmpty(Tag[] tags) {
        return tags != null && tags.length != 0;
    }

    public static String passed(boolean value) {
        return value ? "<div class=\"passed\">" : "</div>";
    }

    public static String formatDuration(Long duration) {
        return TIME_FORMATTER.print((ReadablePeriod)new Period(0L, duration / 1000000L));
    }

    public static int findStatusCount(List<Status> statuses, Status statusToFind) {
        int occurrence = 0;
        for (Status status : statuses) {
            if (status != statusToFind) continue;
            ++occurrence;
        }
        return occurrence;
    }
}

