/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.json.Scenario;
import net.masterthought.cucumber.json.Step;
import net.masterthought.cucumber.json.Tag;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class Feature {
    private final String id;
    private final String name;
    private final String uri;
    private final String description;
    private final String keyword;
    @SerializedName(value="elements")
    private final Scenario[] scenarios = new Scenario[0];
    private final Tag[] tags = new Tag[0];
    private String jsonFile;
    private String reportFileName;
    private String deviceName;
    private final List<Scenario> passedScenarios = new ArrayList<Scenario>();
    private final List<Scenario> failedScenarios = new ArrayList<Scenario>();
    private Status featureStatus;
    private final StatusCounter statusCounter = new StatusCounter();
    private long totalDuration;
    private int totalSteps;

    public Feature() {
        this.id = null;
        this.name = null;
        this.uri = null;
        this.description = null;
        this.keyword = null;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getId() {
        return this.id;
    }

    public Scenario[] getScenarios() {
        return this.scenarios;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    public boolean hasTags() {
        return ArrayUtils.isNotEmpty((Object[])this.tags);
    }

    public boolean hasScenarios() {
        return ArrayUtils.isNotEmpty((Object[])this.scenarios);
    }

    public Tag[] getTags() {
        return this.tags;
    }

    public String getTagsList() {
        return Util.tagsToHtml(this.tags);
    }

    public Status getStatus() {
        return this.featureStatus;
    }

    public String getName() {
        if (StringUtils.isNotEmpty((String)this.name)) {
            return String.format("<div class=\"%s\"><div class=\"feature-line\"><span class=\"feature-keyword\">%s: </span>%s</div></div>", this.getStatus().getName().toLowerCase(), this.keyword, this.name);
        }
        return "";
    }

    public String getRawName() {
        return StringUtils.isNotEmpty((String)this.name) ? StringEscapeUtils.escapeHtml((String)this.name) : "";
    }

    public String getRawStatus() {
        return this.getStatus().toString().toLowerCase();
    }

    public String getDescription() {
        return this.description;
    }

    public int getNumberOfScenarios() {
        return this.scenarios.length;
    }

    public int getNumberOfSteps() {
        return this.totalSteps;
    }

    public int getNumberOfPasses() {
        return this.statusCounter.getValueFor(Status.PASSED);
    }

    public int getNumberOfFailures() {
        return this.statusCounter.getValueFor(Status.FAILED);
    }

    public int getNumberOfPending() {
        return this.statusCounter.getValueFor(Status.PENDING);
    }

    public int getNumberOfSkipped() {
        return this.statusCounter.getValueFor(Status.SKIPPED);
    }

    public int getNumberOfMissing() {
        return this.statusCounter.getValueFor(Status.MISSING);
    }

    public int getNumberOfUndefined() {
        return this.statusCounter.getValueFor(Status.UNDEFINED);
    }

    public String getTotalDuration() {
        return Util.formatDuration(this.totalDuration);
    }

    public int getNumberOfScenariosPassed() {
        return this.passedScenarios.size();
    }

    public int getNumberOfScenariosFailed() {
        return this.failedScenarios.size();
    }

    public void setMetaData(String jsonFile) {
        this.jsonFile = StringUtils.substringAfterLast((String)jsonFile, (String)"/");
        for (Scenario scenario : this.scenarios) {
            scenario.setMedaData(this);
        }
        this.setDeviceName();
        this.setReportFileName();
        this.calculateFeatureStatus();
        this.calculateSteps();
    }

    private void setDeviceName() {
        String[] splitedJsonFile = this.jsonFile.split("[^\\d\\w]");
        this.deviceName = splitedJsonFile.length > 1 ? splitedJsonFile[splitedJsonFile.length - 2] : splitedJsonFile[0];
    }

    private void setReportFileName() {
        this.reportFileName = this.uri.replaceAll("[^\\d\\w]", "-");
        if (ReportBuilder.isParallel()) {
            this.reportFileName = this.reportFileName + "-" + this.getDeviceName();
        }
        this.reportFileName = this.reportFileName + ".html";
    }

    private void calculateFeatureStatus() {
        for (Scenario element : this.scenarios) {
            if (element.getStatus() == Status.PASSED) continue;
            this.featureStatus = Status.FAILED;
            return;
        }
        this.featureStatus = Status.PASSED;
    }

    private void calculateSteps() {
        for (Scenario scenario : this.scenarios) {
            if (scenario.getStatus() == Status.PASSED) {
                this.passedScenarios.add(scenario);
            } else if (scenario.getStatus() == Status.FAILED) {
                this.failedScenarios.add(scenario);
            }
            this.totalSteps += scenario.getSteps().length;
            for (Step step : scenario.getSteps()) {
                this.statusCounter.incrementFor(step.getStatus());
                this.totalDuration += step.getDuration();
            }
        }
    }
}

