/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import net.masterthought.cucumber.json.DocString;
import net.masterthought.cucumber.json.Element;
import net.masterthought.cucumber.json.Embedded;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Row;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class Step
implements ResultsWithMatch {
    private String name = null;
    private final String keyword;
    private final String line;
    private final Result result = null;
    private final Row[] rows = new Row[0];
    private final Match match = null;
    private final Embedded[] embeddings = new Embedded[0];
    private final JsonElement[] output = new JsonElement[0];
    private final DocString doc_string = null;
    private String attachments;
    private String convertedOutput;
    private Status status;

    public Step() {
        this.keyword = null;
        this.line = null;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public String getOutput() {
        return this.convertedOutput;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public boolean hasRows() {
        return ArrayUtils.isNotEmpty((Object[])this.rows);
    }

    public Status getStatus() {
        return this.status;
    }

    public long getDuration() {
        return this.result == null ? 0L : this.result.getDuration();
    }

    public String getDetails() {
        String errorMessage;
        String string = errorMessage = this.result == null ? null : this.result.getErrorMessage();
        if (this.status == Status.MISSING) {
            errorMessage = "<span class=\"missing\">Result was missing for this step</span>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"").append(this.status.getRawName()).append("\">");
        sb.append("<span class=\"step-keyword\">").append(this.keyword).append(" </span>");
        sb.append("<span class=\"step-name\">");
        if (StringUtils.isNotBlank((String)this.name)) {
            sb.append(StringEscapeUtils.escapeHtml((String)this.name));
        }
        sb.append("</span>");
        sb.append("<span class=\"step-duration\">");
        if (this.status != Status.MISSING && this.result != null) {
            sb.append(Util.formatDuration(this.result.getDuration()));
        }
        sb.append("</span>");
        if (StringUtils.isNotBlank((String)errorMessage)) {
            int id = this.result != null ? this.result.hashCode() : errorMessage.hashCode();
            sb.append(Util.formatMessage(errorMessage, id));
        }
        sb.append("</div>");
        return sb.toString();
    }

    public String getDocString() {
        if (this.doc_string == null || StringUtils.isBlank((String)this.doc_string.getValue())) {
            return "";
        }
        return "<div class=\"" + this.status.getRawName() + "\">" + "<div class=\"doc-string\">" + StringEscapeUtils.escapeHtml((String)this.doc_string.getValue()).replaceAll("\n", "<br/>").replaceAll(" ", "&nbsp;") + "</div></div>";
    }

    @Override
    public String getAttachments() {
        return this.attachments;
    }

    public void setMedaData(Element element) {
        this.calculateAttachments();
        this.calculateOutputs();
        this.calculateStatus();
    }

    private void calculateAttachments() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.embeddings.length; ++i) {
            sb.append(this.embeddings[i].render(i));
        }
        if (this.embeddings.length > 0) {
            sb.append("<br>");
        }
        this.attachments = sb.toString();
    }

    private void calculateOutputs() {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.output.length; ++i) {
            JsonElement element = this.output[i];
            if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isString()) {
                list.add(element.getAsString());
                continue;
            }
            list.add(element.toString());
        }
        this.convertedOutput = Util.formatMessage(StringUtils.join(list, (String)"\n"), this.hashCode());
    }

    private void calculateStatus() {
        this.status = this.result == null ? Status.MISSING : Status.toStatus(this.result.getStatus());
    }
}

