/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.generators.AbstractPage;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.lang3.StringUtils;

public class TagsOverviewPage
extends AbstractPage {
    private static final NumberFormat DECIMAL_FORMATTER = DecimalFormat.getInstance(Locale.US);

    public TagsOverviewPage(ReportResult reportResult, Configuration configuration) {
        super(reportResult, "tagsOverview.vm", configuration);
    }

    @Override
    public String getWebPage() {
        return "tag-overview.html";
    }

    @Override
    public void prepareReport() {
        List<TagObject> tags = this.report.getAllTags();
        this.context.put("all_tags", tags);
        this.context.put("report_summary", (Object)this.report.getTagReport());
        this.context.put("chart_categories", (Object)TagsOverviewPage.generateTagLabels(tags));
        this.context.put("chart_data", TagsOverviewPage.generateTagValues(tags));
    }

    static String generateTagLabels(List<TagObject> tagsObjectList) {
        int tagCount = tagsObjectList.size();
        Object[] tagNames = new String[tagCount];
        for (int i = 0; i < tagCount; ++i) {
            tagNames[i] = StringUtils.wrap((String)tagsObjectList.get(i).getName(), (String)"\"");
        }
        return "[" + StringUtils.join((Object[])tagNames, (String)",") + "]";
    }

    static List<String> generateTagValues(List<TagObject> tagsObjectList) {
        int tagsCount = tagsObjectList.size();
        String[][] values = new String[Status.values().length][tagsCount];
        for (int i = 0; i < tagsCount; ++i) {
            TagObject tagObject = tagsObjectList.get(i);
            int allSteps = tagObject.getSteps();
            values[0][i] = TagsOverviewPage.format(tagObject.getPassedSteps(), allSteps);
            values[1][i] = TagsOverviewPage.format(tagObject.getFailedSteps(), allSteps);
            values[2][i] = TagsOverviewPage.format(tagObject.getSkippedSteps(), allSteps);
            values[3][i] = TagsOverviewPage.format(tagObject.getPendingSteps(), allSteps);
            values[4][i] = TagsOverviewPage.format(tagObject.getUndefinedSteps(), allSteps);
            values[5][i] = TagsOverviewPage.format(tagObject.getMissingSteps(), allSteps);
        }
        ArrayList<String> statuses = new ArrayList<String>();
        for (int i = 0; i < Status.values().length; ++i) {
            statuses.add("[" + StringUtils.join((Object[])values[i], (char)',') + "]");
        }
        return statuses;
    }

    static String format(int value, int sum) {
        return DECIMAL_FORMATTER.format(100.0f * (float)value / (float)sum);
    }

    static {
        DECIMAL_FORMATTER.setMinimumFractionDigits(2);
        DECIMAL_FORMATTER.setMaximumFractionDigits(2);
    }
}

