/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import net.masterthought.cucumber.json.DocString;
import net.masterthought.cucumber.json.Embedding;
import net.masterthought.cucumber.json.Match;
import net.masterthought.cucumber.json.Output;
import net.masterthought.cucumber.json.Result;
import net.masterthought.cucumber.json.Row;
import net.masterthought.cucumber.json.support.ResultsWithMatch;
import net.masterthought.cucumber.json.support.Status;
import org.apache.commons.lang3.ArrayUtils;

public class Step
implements ResultsWithMatch {
    private String name = null;
    private final String keyword;
    private final Result result = null;
    private final Row[] rows = new Row[0];
    private final Match match = null;
    private final Embedding[] embeddings = new Embedding[0];
    private final Output output = null;
    @JsonProperty(value="doc_string")
    private final DocString docString = null;
    private Status status;

    public Step() {
        this.keyword = null;
    }

    public Row[] getRows() {
        return this.rows;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyword() {
        return this.keyword.trim();
    }

    public Output getOutput() {
        return this.output;
    }

    @Override
    public Match getMatch() {
        return this.match;
    }

    public Embedding[] getEmbeddings() {
        return this.embeddings;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    public boolean hasRows() {
        return ArrayUtils.isNotEmpty((Object[])this.rows);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public long getDuration() {
        return this.result == null ? 0L : this.result.getDuration();
    }

    public String getErrorMessage() {
        return this.result == null ? null : this.result.getErrorMessage();
    }

    public DocString getDocString() {
        return this.docString;
    }

    public void setMedaData() {
        this.calculateStatus();
    }

    private void calculateStatus() {
        this.status = this.result == null ? Status.MISSING : Status.toStatus(this.result.getStatus());
    }
}

