/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.reports;

import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.json.support.StatusCounter;
import net.masterthought.cucumber.reports.Reportable;
import net.masterthought.cucumber.util.Util;
import org.apache.commons.lang.NotImplementedException;

public class OverviewReport
implements Reportable {
    private final String reportName;
    private long duration;
    private final StatusCounter scenariosCounter = new StatusCounter();
    private final StatusCounter stepsCounter = new StatusCounter();

    public OverviewReport(String reportName) {
        this.reportName = reportName;
    }

    @Override
    public int getScenarios() {
        return this.scenariosCounter.size();
    }

    @Override
    public int getPassedScenarios() {
        return this.scenariosCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedScenarios() {
        return this.scenariosCounter.getValueFor(Status.FAILED);
    }

    public void incScenarioFor(Status status) {
        this.scenariosCounter.incrementFor(status);
    }

    @Override
    public int getSteps() {
        return this.stepsCounter.size();
    }

    @Override
    public int getPassedSteps() {
        return this.stepsCounter.getValueFor(Status.PASSED);
    }

    @Override
    public int getFailedSteps() {
        return this.stepsCounter.getValueFor(Status.FAILED);
    }

    @Override
    public int getSkippedSteps() {
        return this.stepsCounter.getValueFor(Status.SKIPPED);
    }

    @Override
    public int getUndefinedSteps() {
        return this.stepsCounter.getValueFor(Status.UNDEFINED);
    }

    @Override
    public int getMissingSteps() {
        return this.stepsCounter.getValueFor(Status.MISSING);
    }

    @Override
    public int getPendingSteps() {
        return this.stepsCounter.getValueFor(Status.PENDING);
    }

    public void incStepsFor(Status status) {
        this.stepsCounter.incrementFor(status);
    }

    @Override
    public long getDurations() {
        return this.duration;
    }

    @Override
    public String getFormattedDurations() {
        return Util.formatDuration(this.getDurations());
    }

    public void incDurationBy(long duration) {
        this.duration += duration;
    }

    @Override
    public String getDeviceName() {
        throw new NotImplementedException();
    }

    @Override
    public String getName() {
        return this.reportName;
    }

    @Override
    public Status getStatus() {
        throw new NotImplementedException();
    }
}

