/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.masterthought.cucumber.ValidationException;
import org.apache.commons.lang.StringUtils;

public final class Configuration {
    private static final String EMBEDDINGS_DIRECTORY = "embeddings";
    private boolean failsIfSkipped;
    private boolean failsIfPending;
    private boolean failsIfUndefined;
    private boolean parallelTesting;
    private String jenkinsBasePath;
    private boolean runWithJenkins;
    private File reportDirectory;
    private String buildNumber;
    private String projectName;
    private Collection<Pattern> tagsToExcludeFromChart = new ArrayList<Pattern>();

    public Configuration(File reportOutputDirectory, String projectName) {
        this.reportDirectory = reportOutputDirectory;
        this.projectName = projectName;
    }

    public void setStatusFlags(boolean failsIfSkipped, boolean failsIfPending, boolean failsIfUndefined) {
        this.failsIfSkipped = failsIfSkipped;
        this.failsIfPending = failsIfPending;
        this.failsIfUndefined = failsIfUndefined;
    }

    public boolean failsIfSkipped() {
        return this.failsIfSkipped;
    }

    public boolean failsIfPending() {
        return this.failsIfPending;
    }

    public boolean failsIfUndefined() {
        return this.failsIfUndefined;
    }

    public boolean isParallelTesting() {
        return this.parallelTesting;
    }

    public void setParallelTesting(boolean parallelTesting) {
        this.parallelTesting = parallelTesting;
    }

    public String getJenkinsBasePath() {
        return StringUtils.defaultString((String)this.jenkinsBasePath);
    }

    public void setJenkinsBasePath(String jenkinsBase) {
        this.jenkinsBasePath = jenkinsBase;
    }

    public boolean isRunWithJenkins() {
        return this.runWithJenkins;
    }

    public void setRunWithJenkins(boolean runWithJenkins) {
        this.runWithJenkins = runWithJenkins;
    }

    public File getReportDirectory() {
        return this.reportDirectory;
    }

    public String getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public File getEmbeddingDirectory() {
        return new File(this.getReportDirectory().getAbsolutePath(), "cucumber-html-reports" + File.separatorChar + EMBEDDINGS_DIRECTORY);
    }

    public Collection<Pattern> getTagsToExcludeFromChart() {
        return this.tagsToExcludeFromChart;
    }

    public void setTagsToExcludeFromChart(String ... patterns) throws ValidationException {
        for (String pattern : patterns) {
            try {
                this.tagsToExcludeFromChart.add(Pattern.compile(pattern));
            }
            catch (PatternSyntaxException e) {
                throw new ValidationException(e);
            }
        }
    }
}

