/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.Trends;
import net.masterthought.cucumber.generators.AbstractPage;
import org.apache.commons.lang3.StringUtils;

public class TrendsOverviewPage
extends AbstractPage {
    public static final String WEB_PAGE = "overview-trends.html";
    private final Trends trends;

    public TrendsOverviewPage(ReportResult reportResult, Configuration configuration, Trends trends) {
        super(reportResult, "overviewTrends.vm", configuration);
        this.trends = trends;
    }

    @Override
    public String getWebPage() {
        return WEB_PAGE;
    }

    @Override
    public void prepareReport() {
        this.context.put("buildNumbers", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getBuildNumbers()));
        this.context.put("failedFeatures", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getFailedFeatures()));
        this.context.put("totalFeatures", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getTotalFeatures()));
        this.context.put("failedScenarios", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getFailedScenarios()));
        this.context.put("totalScenarios", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getTotalScenarios()));
        this.context.put("passedSteps", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getPassedSteps()));
        this.context.put("failedSteps", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getFailedSteps()));
        this.context.put("skippedSteps", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getSkippedSteps()));
        this.context.put("pendingSteps", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getPendingSteps()));
        this.context.put("undefinedSteps", (Object)TrendsOverviewPage.toJavaScriptArray(this.trends.getUndefinedSteps()));
    }

    private static String toJavaScriptArray(String[] array) {
        int itemCount = array.length;
        Object[] names = new String[itemCount];
        for (int i = 0; i < itemCount; ++i) {
            names[i] = StringUtils.wrap((String)array[i], (String)"\"");
        }
        return "[" + StringUtils.join((Object[])names, (String)",") + "]";
    }

    private static String toJavaScriptArray(int[] array) {
        return "[" + StringUtils.join((int[])array, (char)',') + "]";
    }
}

