/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.reducers.ReducingMethod;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class ReportParser {
    private static final Logger LOG = Logger.getLogger(ReportParser.class.getName());
    private final ObjectMapper mapper = new ObjectMapper();
    private final Configuration configuration;

    public ReportParser(Configuration configuration) {
        this.configuration = configuration;
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        this.mapper.registerModule((Module)new JavaTimeModule());
        InjectableValues.Std values = new InjectableValues.Std().addValue(Configuration.class, (Object)configuration);
        this.mapper.setInjectableValues((InjectableValues)values);
    }

    public List<Feature> parseJsonFiles(List<String> jsonFiles) {
        if (jsonFiles.isEmpty()) {
            throw new ValidationException("None report file was added!");
        }
        ArrayList<Feature> featureResults = new ArrayList<Feature>();
        for (int i = 0; i < jsonFiles.size(); ++i) {
            String jsonFile = jsonFiles.get(i);
            if (new File(jsonFile).length() == 0L && this.configuration.containsReducingMethod(ReducingMethod.SKIP_EMPTY_JSON_FILES)) continue;
            Feature[] features = this.parseForFeature(jsonFile);
            LOG.log(Level.INFO, () -> String.format("File '%s' contains %d features", jsonFile, features.length));
            featureResults.addAll(Arrays.asList(features));
        }
        if (featureResults.isEmpty()) {
            throw new ValidationException("Passed files have no features!");
        }
        return featureResults;
    }

    private Feature[] parseForFeature(String jsonFile) {
        Object[] objectArray;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8);
        try {
            Object[] features = (Feature[])this.mapper.readValue((Reader)reader, Feature[].class);
            if (ArrayUtils.isEmpty((Object[])features)) {
                LOG.log(Level.INFO, () -> String.format("File '%s' does not contain features", jsonFile));
            }
            String jsonFileName = this.extractQualifier(jsonFile);
            Arrays.stream(features).forEach(feature -> feature.setQualifier(StringUtils.defaultString((String)this.configuration.getQualifier(jsonFileName), (String)jsonFileName)));
            objectArray = features;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonMappingException e) {
                throw new ValidationException(String.format("File '%s' is not proper Cucumber report!", jsonFile), (Exception)((Object)e));
            }
            catch (IOException e) {
                throw new ValidationException(e);
            }
        }
        ((Reader)reader).close();
        return objectArray;
    }

    private String extractQualifier(String jsonFileName) {
        File jsonFile = new File(jsonFileName);
        String target = jsonFile.getName();
        String jsonExtension = ".json";
        if (target.toLowerCase().endsWith(".json")) {
            return target.substring(0, target.length() - ".json".length());
        }
        return target;
    }

    public void parseClassificationsFiles(List<String> propertiesFiles) {
        if (CollectionUtils.isNotEmpty(propertiesFiles)) {
            for (String propertyFile : propertiesFiles) {
                if (!StringUtils.isNotEmpty((String)propertyFile)) continue;
                this.processClassificationFile(propertyFile);
            }
        }
    }

    private void processClassificationFile(String file) {
        try {
            PropertiesConfiguration config = new PropertiesConfiguration(file);
            Iterator keys = config.getKeys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                String value = config.getProperty(key).toString();
                this.configuration.addClassifications(key, value);
            }
        }
        catch (ConfigurationException e) {
            throw new ValidationException(String.format("File '%s' doesn't exist or the properties file is invalid!", file), (Exception)((Object)e));
        }
    }
}

