/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.EmptyReportable;
import net.masterthought.cucumber.ReportParser;
import net.masterthought.cucumber.ReportResult;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.Trends;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.generators.ErrorPage;
import net.masterthought.cucumber.generators.FailuresOverviewPage;
import net.masterthought.cucumber.generators.FeatureReportPage;
import net.masterthought.cucumber.generators.FeaturesOverviewPage;
import net.masterthought.cucumber.generators.StepsOverviewPage;
import net.masterthought.cucumber.generators.TagReportPage;
import net.masterthought.cucumber.generators.TagsOverviewPage;
import net.masterthought.cucumber.generators.TrendsOverviewPage;
import net.masterthought.cucumber.json.Feature;
import net.masterthought.cucumber.json.support.TagObject;
import org.apache.commons.io.FileUtils;

public class ReportBuilder {
    private static final Logger LOG = Logger.getLogger(ReportBuilder.class.getName());
    public static final String HOME_PAGE = "overview-features.html";
    public static final String BASE_DIRECTORY = "cucumber-html-reports";
    public static final String SUFFIX_SEPARATOR = "_";
    private static final ObjectMapper mapper = new ObjectMapper();
    private ReportResult reportResult;
    private final ReportParser reportParser;
    private Configuration configuration;
    private List<String> jsonFiles;
    private boolean wasTrendsFileSaved = false;

    public ReportBuilder(List<String> jsonFiles, Configuration configuration) {
        this.jsonFiles = jsonFiles;
        this.configuration = configuration;
        this.reportParser = new ReportParser(configuration);
    }

    public Reportable generateReports() {
        Trends trends = null;
        try {
            this.copyStaticResources();
            this.copyCustomJsAndCssResources();
            this.createEmbeddingsDirectory();
            this.reportParser.parseClassificationsFiles(this.configuration.getClassificationFiles());
            List<Feature> features = this.reportParser.parseJsonFiles(this.jsonFiles);
            this.reportResult = new ReportResult(features, this.configuration);
            Reportable reportable = this.reportResult.getFeatureReport();
            if (this.configuration.isTrendsAvailable()) {
                trends = this.updateAndSaveTrends(reportable);
            }
            this.generatePages(trends);
            return reportable;
        }
        catch (Exception e) {
            this.generateErrorPage(e);
            if (!this.wasTrendsFileSaved && this.configuration.isTrendsAvailable()) {
                EmptyReportable reportable = new EmptyReportable();
                this.updateAndSaveTrends(reportable);
            }
            return null;
        }
    }

    private void copyCustomJsAndCssResources() {
        File file;
        for (String jsFile : this.configuration.getCustomJsFiles()) {
            file = new File(jsFile);
            this.copyCustomResources("js", file);
        }
        for (String cssFile : this.configuration.getCustomCssFiles()) {
            file = new File(cssFile);
            this.copyCustomResources("css", file);
        }
    }

    private void copyStaticResources() {
        this.copyResources("css", "cucumber.css", "bootstrap.min.css", "font-awesome.min.css");
        this.copyResources("js", "jquery.min.js", "jquery.tablesorter.min.js", "bootstrap.min.js", "Chart.min.js", "moment.min.js");
        this.copyResources("fonts", "FontAwesome.otf", "fontawesome-webfont.svg", "fontawesome-webfont.woff", "fontawesome-webfont.eot", "fontawesome-webfont.ttf", "fontawesome-webfont.woff2", "glyphicons-halflings-regular.eot", "glyphicons-halflings-regular.eot", "glyphicons-halflings-regular.woff2", "glyphicons-halflings-regular.woff", "glyphicons-halflings-regular.ttf", "glyphicons-halflings-regular.svg");
        this.copyResources("images", "favicon.png");
    }

    private void createEmbeddingsDirectory() {
        this.configuration.getEmbeddingDirectory().mkdirs();
    }

    private void copyResources(String resourceLocation, String ... resources) {
        for (String resource : resources) {
            File tempFile = this.createTempFile(resourceLocation, resource);
            try {
                FileUtils.copyInputStreamToFile((InputStream)this.getClass().getResourceAsStream("/" + resourceLocation + "/" + resource), (File)tempFile);
            }
            catch (IOException e) {
                throw new ValidationException(e);
            }
        }
    }

    private void copyCustomResources(String resourceLocation, File srcFile) {
        File tempFile = this.createTempFile(resourceLocation, srcFile.getName());
        try {
            FileUtils.copyFile((File)srcFile, (File)tempFile);
        }
        catch (FileNotFoundException e) {
            LOG.log(Level.WARNING, "File not found: {0}", srcFile.getAbsolutePath());
            LOG.log(Level.FINE, "", e);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }

    private File createTempFile(String resourceLocation, String resource) {
        return new File(this.configuration.getReportDirectory().getAbsoluteFile(), BASE_DIRECTORY + this.configuration.getDirectorySuffixWithSeparator() + File.separatorChar + resourceLocation + File.separatorChar + resource);
    }

    private void generatePages(Trends trends) {
        new FeaturesOverviewPage(this.reportResult, this.configuration).generatePage();
        for (Feature feature : this.reportResult.getAllFeatures()) {
            new FeatureReportPage(this.reportResult, this.configuration, feature).generatePage();
        }
        new TagsOverviewPage(this.reportResult, this.configuration).generatePage();
        for (TagObject tagObject : this.reportResult.getAllTags()) {
            new TagReportPage(this.reportResult, this.configuration, tagObject).generatePage();
        }
        new StepsOverviewPage(this.reportResult, this.configuration).generatePage();
        new FailuresOverviewPage(this.reportResult, this.configuration).generatePage();
        if (this.configuration.isTrendsAvailable()) {
            new TrendsOverviewPage(this.reportResult, this.configuration, trends).generatePage();
        }
    }

    private Trends updateAndSaveTrends(Reportable reportable) {
        Trends trends = this.loadOrCreateTrends();
        this.appendToTrends(trends, reportable);
        if (this.configuration.getTrendsLimit() > 0) {
            trends.limitItems(this.configuration.getTrendsLimit());
        }
        this.saveTrends(trends, this.configuration.getTrendsStatsFile());
        return trends;
    }

    private Trends loadOrCreateTrends() {
        File trendsFile = this.configuration.getTrendsStatsFile();
        if (trendsFile != null && trendsFile.exists()) {
            return ReportBuilder.loadTrends(trendsFile);
        }
        return new Trends();
    }

    private static Trends loadTrends(File file) {
        Trends trends;
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), StandardCharsets.UTF_8);
        try {
            trends = (Trends)mapper.readValue((Reader)reader, Trends.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonMappingException e) {
                throw new ValidationException(String.format("File '%s' could not be parsed as file with trends!", file), e);
            }
            catch (IOException e) {
                throw new ValidationException(e);
            }
        }
        ((Reader)reader).close();
        return trends;
    }

    private void appendToTrends(Trends trends, Reportable result) {
        trends.addBuild(this.configuration.getBuildNumber(), result);
    }

    private void saveTrends(Trends trends, File file) {
        ObjectWriter objectWriter = mapper.writer().with(SerializationFeature.INDENT_OUTPUT);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
            objectWriter.writeValue((Writer)writer, (Object)trends);
            this.wasTrendsFileSaved = true;
        }
        catch (IOException e) {
            this.wasTrendsFileSaved = false;
            throw new ValidationException("Could not save updated trends in file: " + file.getAbsolutePath(), e);
        }
    }

    private void generateErrorPage(Exception exception) {
        LOG.log(Level.INFO, "Unexpected error", exception);
        ErrorPage errorPage = new ErrorPage(this.reportResult, this.configuration, exception, this.jsonFiles);
        errorPage.generatePage();
    }
}

