/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.generators;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.owasp.html.HtmlPolicyBuilder;
import org.owasp.html.PolicyFactory;

final class EscapeHtmlReference
implements ReferenceInsertionEventHandler {
    private static final PolicyFactory LINKS = new HtmlPolicyBuilder().allowStandardUrlProtocols().allowElements(new String[]{"a"}).allowAttributes(new String[]{"href"}).onElements(new String[]{"a"}).requireRelNofollowOnLinks().requireRelsOnLinks(new String[]{"noopener", "noreferrer"}).toFactory();

    EscapeHtmlReference() {
    }

    public Object referenceInsert(Context context, String reference, Object value) {
        if (value == null) {
            return null;
        }
        if (reference.startsWith("$_sanitize_")) {
            return LINKS.sanitize(value.toString());
        }
        if (reference.startsWith("$_noescape_")) {
            return value.toString();
        }
        return StringEscapeUtils.escapeHtml((String)value.toString());
    }
}

