/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.sandwich;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.sandwich.SandwichParameters;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.codehaus.plexus.util.DirectoryScanner;

public class CucumberReportMonitor {
    public static void main(String[] args) throws Exception {
        SandwichParameters params = new SandwichParameters();
        JCommander cmd = new JCommander((Object)params);
        long pollingInterval = 5000L;
        try {
            cmd.parse(args);
            final File reportFolder = new File(params.getFolder());
            final File outputFolder = new File(params.getOutDir());
            CucumberReportMonitor.createMonitorFolder(reportFolder);
            System.out.println("Starting Cucumber Sandwich.....");
            if (params.getWithoutListener().booleanValue()) {
                System.out.println("Running once only as -n flag supplied.....");
                CucumberReportMonitor.generateReport(reportFolder, outputFolder);
            } else {
                System.out.println("Listening for change in folder: " + reportFolder.getAbsoluteFile());
                FileAlterationObserver observer = new FileAlterationObserver(reportFolder);
                FileAlterationMonitor monitor = new FileAlterationMonitor(5000L);
                FileAlterationListenerAdaptor listener = new FileAlterationListenerAdaptor(){

                    public void onFileCreate(File file) {
                        try {
                            System.out.println("File created: " + file.getCanonicalPath());
                            CucumberReportMonitor.generateReport(reportFolder, outputFolder);
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                        }
                    }

                    public void onFileChange(File file) {
                        try {
                            System.out.println("File changed: " + file.getCanonicalPath());
                            CucumberReportMonitor.generateReport(reportFolder, outputFolder);
                        }
                        catch (IOException e) {
                            e.printStackTrace(System.err);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                observer.addListener((FileAlterationListener)listener);
                monitor.addObserver(observer);
                monitor.start();
            }
        }
        catch (ParameterException ex) {
            System.out.println(ex.getMessage());
            cmd.usage();
        }
    }

    private static String[] findJsonFiles(File targetDirectory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(new String[]{"**/*.json"});
        scanner.setBasedir(targetDirectory);
        scanner.scan();
        return scanner.getIncludedFiles();
    }

    private static void generateReport(File reportFolder, File outputFolder) throws Exception {
        File rd = new File(outputFolder + "/cucumber-html-reports");
        List<String> jsonFileList = CucumberReportMonitor.findJsonReports(reportFolder);
        System.out.println("About to generate Cucumber Report into: " + rd.getAbsoluteFile());
        Configuration configuration = new Configuration(rd, "cucumber-jvm");
        ReportBuilder reportBuilder = new ReportBuilder(jsonFileList, configuration);
        reportBuilder.generateReports();
        System.out.println("Finished generating Cucumber Report into: " + rd.getAbsoluteFile());
    }

    private static List<String> findJsonReports(File reportFolder) {
        String[] jsonFiles = CucumberReportMonitor.findJsonFiles(reportFolder);
        ArrayList<String> reports = new ArrayList<String>();
        System.out.println("Found json reports: " + jsonFiles.length);
        String reportPath = reportFolder.getAbsolutePath();
        for (int i = 0; i < jsonFiles.length; ++i) {
            String reportJson = reportPath + "/" + jsonFiles[i];
            System.out.println(reportJson);
            reports.add(reportJson);
        }
        return reports;
    }

    private static void createMonitorFolder(File reportFolder) {
        if (!reportFolder.exists()) {
            System.out.println("creating report directory: " + reportFolder.getAbsolutePath());
            boolean result = reportFolder.mkdirs();
            if (result) {
                System.out.println("created report directory: " + reportFolder.getAbsoluteFile());
            }
        }
    }
}

