/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.reducers.ReducingMethod;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class CucumberReportGeneratorMojo
extends AbstractMojo {
    private String projectName;
    private String buildNumber;
    private File outputDirectory;
    private File inputDirectory;
    private String[] jsonFiles;
    private File classificationDirectory;
    private int trendsLimit;
    private File trendsFile;
    private String[] classificationFiles;
    private Boolean checkBuildResult;
    private Boolean treatUndefinedAsFailed;
    private Boolean treatPendingAsFailed;
    private Map<String, String> classifications;
    private boolean skip;
    private boolean mergeFeaturesById;
    private boolean skipEmptyJSONFiles;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Cucumber report generation is skipped.");
            return;
        }
        if (this.inputDirectory == null) {
            this.inputDirectory = this.outputDirectory;
        }
        if (this.classificationDirectory == null) {
            this.classificationDirectory = this.outputDirectory;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        List<String> jsonFilesToProcess = CucumberReportGeneratorMojo.genericFindFiles(this.inputDirectory, this.jsonFiles);
        List<String> classificationFilesToProcess = CucumberReportGeneratorMojo.genericFindFiles(this.classificationDirectory, this.classificationFiles);
        try {
            Configuration configuration = new Configuration(this.outputDirectory, this.projectName);
            configuration.setBuildNumber(this.buildNumber);
            if (this.mergeFeaturesById) {
                configuration.addReducingMethod(ReducingMethod.MERGE_FEATURES_BY_ID);
            }
            if (!MapUtils.isEmpty(this.classifications)) {
                for (Map.Entry<String, String> entry : this.classifications.entrySet()) {
                    configuration.addClassifications(StringUtils.capitalise((String)entry.getKey()), entry.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(classificationFilesToProcess)) {
                configuration.addClassificationFiles(classificationFilesToProcess);
            }
            if (this.mergeFeaturesById) {
                configuration.addReducingMethod(ReducingMethod.MERGE_FEATURES_BY_ID);
            }
            if (this.skipEmptyJSONFiles) {
                configuration.addReducingMethod(ReducingMethod.SKIP_EMPTY_JSON_FILES);
            }
            if (this.trendsFile != null) {
                configuration.setTrends(this.trendsFile, this.trendsLimit);
            }
            ReportBuilder reportBuilder = new ReportBuilder(jsonFilesToProcess, configuration);
            this.getLog().info((CharSequence)"About to generate Cucumber report.");
            Reportable report = reportBuilder.generateReports();
            if (this.checkBuildResult.booleanValue() && (report == null || report.getFailedSteps() > 0 || this.treatUndefinedAsFailed.booleanValue() && report.getUndefinedSteps() > 0 || this.treatPendingAsFailed.booleanValue() && report.getPendingSteps() > 0)) {
                throw new MojoExecutionException("BUILD FAILED - Check Report For Details");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Found:", e);
        }
    }

    static List<String> genericFindFiles(File targetDirectory, String[] fileIncludePattern) {
        if (ArrayUtils.isEmpty((Object[])fileIncludePattern)) {
            return Collections.emptyList();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(fileIncludePattern);
        scanner.setBasedir(targetDirectory);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        return CucumberReportGeneratorMojo.fullPathToFiles(files, targetDirectory);
    }

    private static List<String> fullPathToFiles(String[] files, File targetDirectory) {
        ArrayList<String> fullPathList = new ArrayList<String>();
        for (String file : files) {
            fullPathList.add(new File(targetDirectory, file).getAbsolutePath());
        }
        return fullPathList;
    }
}

