/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ReportBuilder;
import net.masterthought.cucumber.Reportable;
import net.masterthought.cucumber.json.support.Status;
import net.masterthought.cucumber.reducers.ReducingMethod;
import net.masterthought.cucumber.sorting.SortingMethod;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.DirectoryScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="generate", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public class CucumberReportGeneratorMojo
extends AbstractMojo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberReportGeneratorMojo.class);
    @Parameter(property="project.name", required=true)
    private String projectName;
    @Parameter(property="build.number", defaultValue="1")
    private String buildNumber;
    @Parameter(defaultValue="${project.build.directory}/cucumber-reports", required=true)
    private File outputDirectory;
    @Parameter
    private File inputDirectory;
    @Parameter(required=true)
    private String[] jsonFiles;
    @Parameter
    private File classificationDirectory;
    @Parameter
    private int trendsLimit;
    @Parameter
    private File trendsFile;
    @Parameter
    private String[] classificationFiles;
    @Parameter
    private String[] excludedTagsFromReport;
    @Parameter(defaultValue="true", required=true)
    private Boolean checkBuildResult;
    @Parameter(defaultValue="false")
    private Boolean treatScenariosAsFailed;
    @Parameter(defaultValue="false")
    private Boolean treatUndefinedAsFailed;
    @Parameter(defaultValue="false")
    private Boolean treatPendingAsFailed;
    @Parameter(defaultValue="false")
    private Boolean treatSkippedAsFailed;
    @Parameter
    private Map<String, String> classifications;
    @Parameter(property="cucumber.report.skip", defaultValue="false")
    private boolean skip;
    @Parameter
    private boolean mergeFeaturesById;
    @Parameter
    private boolean mergeFeaturesWithRetest;
    @Parameter
    private boolean skipEmptyJSONFiles;
    @Parameter
    private boolean setSkippedAsNotFailing;
    @Parameter
    private String sortingMethod;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            LOGGER.info("Cucumber report generation is skipped.");
            return;
        }
        if (this.inputDirectory == null) {
            this.inputDirectory = this.outputDirectory;
        }
        if (this.classificationDirectory == null) {
            this.classificationDirectory = this.outputDirectory;
        }
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        List<String> jsonFilesToProcess = CucumberReportGeneratorMojo.genericFindFiles(this.inputDirectory, this.jsonFiles);
        List<String> classificationFilesToProcess = CucumberReportGeneratorMojo.genericFindFiles(this.classificationDirectory, this.classificationFiles);
        try {
            Configuration configuration = new Configuration(this.outputDirectory, this.projectName);
            configuration.setBuildNumber(this.buildNumber);
            if (this.mergeFeaturesById) {
                configuration.addReducingMethod(ReducingMethod.MERGE_FEATURES_BY_ID);
            }
            if (MapUtils.isNotEmpty(this.classifications)) {
                for (Map.Entry<String, String> entry : this.classifications.entrySet()) {
                    configuration.addClassifications(StringUtils.capitalize((String)entry.getKey()), entry.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(classificationFilesToProcess)) {
                configuration.addClassificationFiles(classificationFilesToProcess);
            }
            if (ArrayUtils.isNotEmpty((Object[])this.excludedTagsFromReport)) {
                configuration.setTagsToExcludeFromChart(this.excludedTagsFromReport);
            }
            if (this.mergeFeaturesById) {
                configuration.addReducingMethod(ReducingMethod.MERGE_FEATURES_BY_ID);
            }
            if (this.mergeFeaturesWithRetest) {
                configuration.addReducingMethod(ReducingMethod.MERGE_FEATURES_WITH_RETEST);
            }
            if (this.skipEmptyJSONFiles) {
                configuration.addReducingMethod(ReducingMethod.SKIP_EMPTY_JSON_FILES);
            }
            if (this.setSkippedAsNotFailing) {
                configuration.setNotFailingStatuses(Collections.singleton(Status.SKIPPED));
            }
            if (this.trendsFile != null) {
                configuration.setTrends(this.trendsFile, this.trendsLimit);
            }
            if (this.sortingMethod != null) {
                configuration.setSortingMethod(SortingMethod.valueOf((String)this.sortingMethod));
            }
            ReportBuilder reportBuilder = new ReportBuilder(jsonFilesToProcess, configuration);
            LOGGER.info("About to generate Cucumber report.");
            Reportable report = reportBuilder.generateReports();
            if (this.checkBuildResult.booleanValue() && (report == null || report.getFailedSteps() > 0 || this.treatScenariosAsFailed != false && report.getFailedScenarios() > 0 || this.treatUndefinedAsFailed != false && report.getUndefinedSteps() > 0 || this.treatPendingAsFailed != false && report.getPendingSteps() > 0 || this.treatSkippedAsFailed.booleanValue() && report.getSkippedSteps() > 0)) {
                throw new MojoExecutionException("BUILD FAILED - Check Report For Details");
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error Found:", e);
        }
    }

    static List<String> genericFindFiles(File targetDirectory, String[] fileIncludePattern) {
        if (ArrayUtils.isEmpty((Object[])fileIncludePattern)) {
            return Collections.emptyList();
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(fileIncludePattern);
        scanner.setBasedir(targetDirectory);
        scanner.scan();
        String[] files = scanner.getIncludedFiles();
        return CucumberReportGeneratorMojo.fullPathToFiles(files, targetDirectory);
    }

    private static List<String> fullPathToFiles(String[] files, File targetDirectory) {
        ArrayList<String> fullPathList = new ArrayList<String>();
        for (String file : files) {
            fullPathList.add(new File(targetDirectory, file).getAbsolutePath());
        }
        return fullPathList;
    }
}

