/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.specialsource;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.md_5.specialsource.AccessMap;
import net.md_5.specialsource.InheritanceMap;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.NodeType;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class RemapperProcessor {
    public boolean debug = false;
    private InheritanceMap inheritanceMap;
    private JarMapping jarMapping;
    private AccessMap accessMap;
    private boolean remapReflectField;
    private boolean remapReflectClass;

    public RemapperProcessor(InheritanceMap inheritanceMap, JarMapping jarMapping, AccessMap accessMap) {
        this.inheritanceMap = inheritanceMap;
        this.jarMapping = jarMapping;
        this.accessMap = accessMap;
        this.remapReflectField = true;
        this.remapReflectClass = false;
    }

    public RemapperProcessor(InheritanceMap inheritanceMap, JarMapping jarMapping) {
        this(inheritanceMap, jarMapping, null);
    }

    public byte[] process(InputStream inputStream) throws IOException {
        return this.process(new ClassReader(inputStream));
    }

    public byte[] process(byte[] bytecode) {
        return this.process(new ClassReader(bytecode));
    }

    public void setRemapReflectField(boolean b) {
        this.remapReflectField = b;
    }

    public void setRemapReflectClass(boolean b) {
        this.remapReflectClass = b;
    }

    public byte[] process(ClassReader classReader) {
        byte[] bytecode = null;
        ClassNode classNode = new ClassNode();
        int flags = 0;
        if (!this.isRewritingNeeded()) {
            flags |= 7;
        }
        classReader.accept(classNode, flags);
        String className = classNode.name;
        if (this.inheritanceMap != null) {
            this.logI("Loading plugin class inheritance for " + className);
            Iterator<InnerClassNode> parents = new ArrayList();
            for (String iface : classNode.interfaces) {
                ((ArrayList)((Object)parents)).add((InnerClassNode)((Object)iface));
            }
            ((ArrayList)((Object)parents)).add((InnerClassNode)((Object)classNode.superName));
            this.inheritanceMap.setParents(className.replace('.', '/'), (Collection<String>)((Object)parents));
            this.logI("Inheritance added " + className + " parents " + ((ArrayList)((Object)parents)).size());
        }
        if (this.isRewritingNeeded()) {
            if (this.accessMap != null) {
                classNode.access = this.accessMap.applyClassAccess(className, classNode.access);
                for (InnerClassNode inner : classNode.innerClasses) {
                    inner.access = this.accessMap.applyClassAccess(inner.name, inner.access);
                }
            }
            if (this.accessMap != null) {
                for (FieldNode fieldNode : classNode.fields) {
                    fieldNode.access = this.accessMap.applyFieldAccess(className, fieldNode.name, fieldNode.access);
                }
            }
            for (MethodNode methodNode : classNode.methods) {
                if (this.accessMap != null) {
                    methodNode.access = this.accessMap.applyMethodAccess(className, methodNode.name, methodNode.desc, methodNode.access);
                }
                if (this.jarMapping == null) continue;
                block8: for (AbstractInsnNode insn = methodNode.instructions.getFirst(); insn != null; insn = insn.getNext()) {
                    switch (insn.getOpcode()) {
                        case 182: {
                            this.remapGetDeclaredField(insn);
                            continue block8;
                        }
                        case 184: {
                            this.remapClassForName(insn);
                        }
                    }
                }
            }
            ClassWriter cw = new ClassWriter(0);
            classNode.accept(cw);
            bytecode = cw.toByteArray();
        }
        return bytecode;
    }

    private boolean isRewritingNeeded() {
        return this.jarMapping != null || this.accessMap != null;
    }

    private void remapGetDeclaredField(AbstractInsnNode insn) {
        if (!this.remapReflectField) {
            return;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        if (!(mi.owner.equals("java/lang/Class") && mi.name.equals("getDeclaredField") && mi.desc.equals("(Ljava/lang/String;)Ljava/lang/reflect/Field;"))) {
            return;
        }
        this.logR("ReflectionRemapper found getDeclaredField!");
        if (insn.getPrevious() == null || insn.getPrevious().getOpcode() != 18) {
            this.logR("- not constant field; skipping, prev=" + insn.getPrevious());
            return;
        }
        LdcInsnNode ldcField = (LdcInsnNode)insn.getPrevious();
        if (!(ldcField.cst instanceof String)) {
            this.logR("- not field string; skipping: " + ldcField.cst);
            return;
        }
        String fieldName = (String)ldcField.cst;
        if (ldcField.getPrevious() == null || ldcField.getPrevious().getOpcode() != 18) {
            this.logR("- not constant class; skipping: field=" + ldcField.cst);
            return;
        }
        LdcInsnNode ldcClass = (LdcInsnNode)ldcField.getPrevious();
        if (!(ldcClass.cst instanceof Type)) {
            this.logR("- not class type; skipping: field=" + ldcClass.cst + ", class=" + ldcClass.cst);
            return;
        }
        String className = ((Type)ldcClass.cst).getInternalName();
        String newName = this.jarMapping.tryClimb(this.jarMapping.fields, NodeType.FIELD, className, fieldName, null, 0);
        this.logR("Remapping " + className + "/" + fieldName + " -> " + newName);
        if (newName != null) {
            ldcField.cst = newName;
        }
    }

    private void remapClassForName(AbstractInsnNode insn) {
        if (!this.remapReflectClass) {
            return;
        }
        MethodInsnNode mi = (MethodInsnNode)insn;
        if (!(mi.owner.equals("java/lang/Class") && mi.name.equals("forName") && mi.desc.equals("(Ljava/lang/String;)Ljava/lang/Class;"))) {
            return;
        }
        this.logR("ReflectionRemapped found Class forName!");
        if (insn.getPrevious() == null || insn.getPrevious().getOpcode() != 18) {
            this.logR("- not constant field; skipping, prev=" + insn.getPrevious());
            return;
        }
        LdcInsnNode ldcClassName = (LdcInsnNode)insn.getPrevious();
        if (!(ldcClassName.cst instanceof String)) {
            this.logR("- not field string; skipping: " + ldcClassName.cst);
            return;
        }
        String className = (String)ldcClassName.cst;
        String newName = this.jarMapping.classes.get(className.replace('.', '/'));
        this.logR("Remapping " + className + " -> " + newName);
        if (newName != null) {
            ldcClassName.cst = newName.replace('/', '.');
        }
    }

    private void logI(String message) {
        if (this.debug) {
            System.out.println("[Inheritance] " + message);
        }
    }

    private void logR(String message) {
        if (this.debug) {
            System.out.println("[ReflectionRemapper] " + message);
        }
    }
}

