/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.plugin;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginDescription;

final class PluginClassloader
extends URLClassLoader {
    private static final Set<PluginClassloader> allLoaders = new CopyOnWriteArraySet<PluginClassloader>();
    private final ProxyServer proxy;
    private final PluginDescription desc;
    private final JarFile jar;
    private final Manifest manifest;
    private final URL url;
    private final ClassLoader libraryLoader;
    private Plugin plugin;

    public PluginClassloader(ProxyServer proxy, PluginDescription desc, File file, ClassLoader libraryLoader) throws IOException {
        super(new URL[]{file.toURI().toURL()});
        this.proxy = proxy;
        this.desc = desc;
        this.jar = new JarFile(file);
        this.manifest = this.jar.getManifest();
        this.url = file.toURI().toURL();
        this.libraryLoader = libraryLoader;
        allLoaders.add(this);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return this.loadClass0(name, resolve, true, true);
    }

    private Class<?> loadClass0(String name, boolean resolve, boolean checkOther, boolean checkLibraries) throws ClassNotFoundException {
        try {
            Class<?> result = super.loadClass(name, resolve);
            if (checkOther || result.getClassLoader() == this) {
                return result;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (checkLibraries && this.libraryLoader != null) {
            try {
                return this.libraryLoader.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (checkOther) {
            for (PluginClassloader loader : allLoaders) {
                if (loader == this) continue;
                try {
                    return loader.loadClass0(name, resolve, false, this.proxy.getPluginManager().isTransitiveDepend(this.desc, loader.desc));
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String path = name.replace('.', '/').concat(".class");
        JarEntry entry = this.jar.getJarEntry(path);
        if (entry != null) {
            byte[] classBytes;
            block21: {
                String pkgName;
                try (InputStream is = this.jar.getInputStream(entry);){
                    classBytes = ByteStreams.toByteArray((InputStream)is);
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException(name, ex);
                }
                int dot = name.lastIndexOf(46);
                if (dot != -1 && this.getPackage(pkgName = name.substring(0, dot)) == null) {
                    try {
                        if (this.manifest != null) {
                            this.definePackage(pkgName, this.manifest, this.url);
                        } else {
                            this.definePackage(pkgName, null, null, null, null, null, null, null);
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        if (this.getPackage(pkgName) != null) break block21;
                        throw new IllegalStateException("Cannot find package " + pkgName);
                    }
                }
            }
            CodeSigner[] signers = entry.getCodeSigners();
            CodeSource source = new CodeSource(this.url, signers);
            return this.defineClass(name, classBytes, 0, classBytes.length, source);
        }
        return super.findClass(name);
    }

    @Override
    public void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.jar.close();
        }
    }

    void init(Plugin plugin) {
        Preconditions.checkArgument((plugin != null ? 1 : 0) != 0, (Object)"plugin");
        Preconditions.checkArgument((plugin.getClass().getClassLoader() == this ? 1 : 0) != 0, (Object)"Plugin has incorrect ClassLoader");
        if (this.plugin != null) {
            throw new IllegalArgumentException("Plugin already initialized!");
        }
        this.plugin = plugin;
        plugin.init(this.proxy, this.desc);
    }

    public String toString() {
        return "PluginClassloader(desc=" + this.desc + ")";
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }
}

