/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.chat;

import com.google.common.base.Preconditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Locale;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentStyle;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.chat.ComponentStyleSerializer;

public class BaseComponentSerializer {
    protected void deserialize(JsonObject object, BaseComponent component, JsonDeserializationContext context) {
        JsonObject event;
        component.applyStyle((ComponentStyle)context.deserialize((JsonElement)object, ComponentStyle.class));
        if (object.has("insertion")) {
            component.setInsertion(object.get("insertion").getAsString());
        }
        if (object.has("clickEvent")) {
            event = object.getAsJsonObject("clickEvent");
            component.setClickEvent(new ClickEvent(ClickEvent.Action.valueOf(event.get("action").getAsString().toUpperCase(Locale.ROOT)), event.has("value") ? event.get("value").getAsString() : ""));
        }
        if (object.has("hoverEvent")) {
            event = object.getAsJsonObject("hoverEvent");
            HoverEvent hoverEvent = null;
            HoverEvent.Action action = HoverEvent.Action.valueOf(event.get("action").getAsString().toUpperCase(Locale.ROOT));
            if (event.has("value")) {
                JsonElement contents = event.get("value");
                BaseComponent[] components = contents.isJsonArray() ? (BaseComponent[])context.deserialize(contents, BaseComponent[].class) : new BaseComponent[]{(BaseComponent)context.deserialize(contents, BaseComponent.class)};
                hoverEvent = new HoverEvent(action, components);
            } else if (event.has("contents")) {
                JsonElement contents = event.get("contents");
                Content[] list = contents.isJsonArray() ? (Content[])context.deserialize(contents, HoverEvent.getClass(action, true)) : new Content[]{(Content)context.deserialize(contents, HoverEvent.getClass(action, false))};
                hoverEvent = new HoverEvent(action, new ArrayList<Content>(Arrays.asList(list)));
            }
            if (hoverEvent != null) {
                component.setHoverEvent(hoverEvent);
            }
        }
        if (object.has("extra")) {
            component.setExtra(Arrays.asList((Object[])context.deserialize(object.get("extra"), BaseComponent[].class)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serialize(JsonObject object, BaseComponent component, JsonSerializationContext context) {
        boolean first = false;
        if (ComponentSerializer.serializedComponents.get() == null) {
            first = true;
            ComponentSerializer.serializedComponents.set(Collections.newSetFromMap(new IdentityHashMap()));
        }
        try {
            Preconditions.checkArgument((!ComponentSerializer.serializedComponents.get().contains(component) ? 1 : 0) != 0, (Object)"Component loop");
            ComponentSerializer.serializedComponents.get().add(component);
            ComponentStyleSerializer.serializeTo(component.getStyle(), object);
            if (component.getInsertion() != null) {
                object.addProperty("insertion", component.getInsertion());
            }
            if (component.getClickEvent() != null) {
                JsonObject clickEvent = new JsonObject();
                clickEvent.addProperty("action", component.getClickEvent().getAction().toString().toLowerCase(Locale.ROOT));
                clickEvent.addProperty("value", component.getClickEvent().getValue());
                object.add("clickEvent", (JsonElement)clickEvent);
            }
            if (component.getHoverEvent() != null) {
                JsonObject hoverEvent = new JsonObject();
                hoverEvent.addProperty("action", component.getHoverEvent().getAction().toString().toLowerCase(Locale.ROOT));
                if (component.getHoverEvent().isLegacy()) {
                    hoverEvent.add("value", context.serialize((Object)component.getHoverEvent().getContents().get(0)));
                } else {
                    hoverEvent.add("contents", context.serialize(component.getHoverEvent().getContents().size() == 1 ? component.getHoverEvent().getContents().get(0) : component.getHoverEvent().getContents()));
                }
                object.add("hoverEvent", (JsonElement)hoverEvent);
            }
            if (component.getExtra() != null) {
                object.add("extra", context.serialize(component.getExtra()));
            }
        }
        finally {
            ComponentSerializer.serializedComponents.get().remove(component);
            if (first) {
                ComponentSerializer.serializedComponents.set(null);
            }
        }
    }
}

