/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import se.llbit.nbt.NamedTag;
import se.llbit.nbt.Tag;

public class Login
extends DefinedPacket {
    private int entityId;
    private short gameMode;
    private short previousGameMode;
    private Set<String> worldNames;
    private Tag dimensions;
    private Object dimension;
    private String worldName;
    private long seed;
    private short difficulty;
    private short maxPlayers;
    private String levelType;
    private int viewDistance;
    private boolean reducedDebugInfo;
    private boolean normalRespawn;
    private boolean debug;
    private boolean flat;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.entityId = buf.readInt();
        this.gameMode = buf.readUnsignedByte();
        if (protocolVersion >= 735) {
            this.previousGameMode = buf.readUnsignedByte();
            this.worldNames = new HashSet<String>();
            int worldCount = Login.readVarInt(buf);
            Preconditions.checkArgument((worldCount < 128 ? 1 : 0) != 0, (String)"Too many worlds %s", (int)worldCount);
            for (int i = 0; i < worldCount; ++i) {
                this.worldNames.add(Login.readString(buf));
            }
            this.dimensions = NamedTag.read((DataInputStream)new DataInputStream((InputStream)new ByteBufInputStream(buf)));
            Preconditions.checkArgument((!this.dimensions.isError() ? 1 : 0) != 0, (String)"Error reading dimensions: %s", (Object)this.dimensions.error());
        }
        if (protocolVersion >= 735) {
            this.dimension = Login.readString(buf);
            this.worldName = Login.readString(buf);
        } else {
            this.dimension = protocolVersion > 107 ? Integer.valueOf(buf.readInt()) : Integer.valueOf(buf.readByte());
        }
        if (protocolVersion >= 573) {
            this.seed = buf.readLong();
        }
        if (protocolVersion < 477) {
            this.difficulty = buf.readUnsignedByte();
        }
        this.maxPlayers = buf.readUnsignedByte();
        if (protocolVersion < 735) {
            this.levelType = Login.readString(buf);
        }
        if (protocolVersion >= 477) {
            this.viewDistance = Login.readVarInt(buf);
        }
        if (protocolVersion >= 29) {
            this.reducedDebugInfo = buf.readBoolean();
        }
        if (protocolVersion >= 573) {
            this.normalRespawn = buf.readBoolean();
        }
        if (protocolVersion >= 735) {
            this.debug = buf.readBoolean();
            this.flat = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        buf.writeInt(this.entityId);
        buf.writeByte((int)this.gameMode);
        if (protocolVersion >= 735) {
            buf.writeByte((int)this.previousGameMode);
            Login.writeVarInt(this.worldNames.size(), buf);
            for (String world : this.worldNames) {
                Login.writeString(world, buf);
            }
            try {
                this.dimensions.write(new DataOutputStream((OutputStream)new ByteBufOutputStream(buf)));
            }
            catch (IOException ex) {
                throw new RuntimeException("Exception writing dimensions", ex);
            }
        }
        if (protocolVersion >= 735) {
            Login.writeString((String)this.dimension, buf);
            Login.writeString(this.worldName, buf);
        } else if (protocolVersion > 107) {
            buf.writeInt(((Integer)this.dimension).intValue());
        } else {
            buf.writeByte(((Integer)this.dimension).intValue());
        }
        if (protocolVersion >= 573) {
            buf.writeLong(this.seed);
        }
        if (protocolVersion < 477) {
            buf.writeByte((int)this.difficulty);
        }
        buf.writeByte((int)this.maxPlayers);
        if (protocolVersion < 735) {
            Login.writeString(this.levelType, buf);
        }
        if (protocolVersion >= 477) {
            Login.writeVarInt(this.viewDistance, buf);
        }
        if (protocolVersion >= 29) {
            buf.writeBoolean(this.reducedDebugInfo);
        }
        if (protocolVersion >= 573) {
            buf.writeBoolean(this.normalRespawn);
        }
        if (protocolVersion >= 735) {
            buf.writeBoolean(this.debug);
            buf.writeBoolean(this.flat);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public short getGameMode() {
        return this.gameMode;
    }

    public short getPreviousGameMode() {
        return this.previousGameMode;
    }

    public Set<String> getWorldNames() {
        return this.worldNames;
    }

    public Tag getDimensions() {
        return this.dimensions;
    }

    public Object getDimension() {
        return this.dimension;
    }

    public String getWorldName() {
        return this.worldName;
    }

    public long getSeed() {
        return this.seed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public short getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public boolean isNormalRespawn() {
        return this.normalRespawn;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public void setGameMode(short gameMode) {
        this.gameMode = gameMode;
    }

    public void setPreviousGameMode(short previousGameMode) {
        this.previousGameMode = previousGameMode;
    }

    public void setWorldNames(Set<String> worldNames) {
        this.worldNames = worldNames;
    }

    public void setDimensions(Tag dimensions) {
        this.dimensions = dimensions;
    }

    public void setDimension(Object dimension) {
        this.dimension = dimension;
    }

    public void setWorldName(String worldName) {
        this.worldName = worldName;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public void setMaxPlayers(short maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    public void setNormalRespawn(boolean normalRespawn) {
        this.normalRespawn = normalRespawn;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setFlat(boolean flat) {
        this.flat = flat;
    }

    @Override
    public String toString() {
        return "Login(entityId=" + this.getEntityId() + ", gameMode=" + this.getGameMode() + ", previousGameMode=" + this.getPreviousGameMode() + ", worldNames=" + this.getWorldNames() + ", dimensions=" + this.getDimensions() + ", dimension=" + this.getDimension() + ", worldName=" + this.getWorldName() + ", seed=" + this.getSeed() + ", difficulty=" + this.getDifficulty() + ", maxPlayers=" + this.getMaxPlayers() + ", levelType=" + this.getLevelType() + ", viewDistance=" + this.getViewDistance() + ", reducedDebugInfo=" + this.isReducedDebugInfo() + ", normalRespawn=" + this.isNormalRespawn() + ", debug=" + this.isDebug() + ", flat=" + this.isFlat() + ")";
    }

    public Login() {
    }

    public Login(int entityId, short gameMode, short previousGameMode, Set<String> worldNames, Tag dimensions, Object dimension, String worldName, long seed, short difficulty, short maxPlayers, String levelType, int viewDistance, boolean reducedDebugInfo, boolean normalRespawn, boolean debug, boolean flat) {
        this.entityId = entityId;
        this.gameMode = gameMode;
        this.previousGameMode = previousGameMode;
        this.worldNames = worldNames;
        this.dimensions = dimensions;
        this.dimension = dimension;
        this.worldName = worldName;
        this.seed = seed;
        this.difficulty = difficulty;
        this.maxPlayers = maxPlayers;
        this.levelType = levelType;
        this.viewDistance = viewDistance;
        this.reducedDebugInfo = reducedDebugInfo;
        this.normalRespawn = normalRespawn;
        this.debug = debug;
        this.flat = flat;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Login)) {
            return false;
        }
        Login other = (Login)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getEntityId() != other.getEntityId()) {
            return false;
        }
        if (this.getGameMode() != other.getGameMode()) {
            return false;
        }
        if (this.getPreviousGameMode() != other.getPreviousGameMode()) {
            return false;
        }
        Set<String> this$worldNames = this.getWorldNames();
        Set<String> other$worldNames = other.getWorldNames();
        if (this$worldNames == null ? other$worldNames != null : !((Object)this$worldNames).equals(other$worldNames)) {
            return false;
        }
        Tag this$dimensions = this.getDimensions();
        Tag other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) {
            return false;
        }
        Object this$dimension = this.getDimension();
        Object other$dimension = other.getDimension();
        if (this$dimension == null ? other$dimension != null : !this$dimension.equals(other$dimension)) {
            return false;
        }
        String this$worldName = this.getWorldName();
        String other$worldName = other.getWorldName();
        if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
            return false;
        }
        if (this.getSeed() != other.getSeed()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        if (this.getMaxPlayers() != other.getMaxPlayers()) {
            return false;
        }
        String this$levelType = this.getLevelType();
        String other$levelType = other.getLevelType();
        if (this$levelType == null ? other$levelType != null : !this$levelType.equals(other$levelType)) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.isReducedDebugInfo() != other.isReducedDebugInfo()) {
            return false;
        }
        if (this.isNormalRespawn() != other.isNormalRespawn()) {
            return false;
        }
        if (this.isDebug() != other.isDebug()) {
            return false;
        }
        return this.isFlat() == other.isFlat();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Login;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getEntityId();
        result = result * 59 + this.getGameMode();
        result = result * 59 + this.getPreviousGameMode();
        Set<String> $worldNames = this.getWorldNames();
        result = result * 59 + ($worldNames == null ? 43 : ((Object)$worldNames).hashCode());
        Tag $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : $dimensions.hashCode());
        Object $dimension = this.getDimension();
        result = result * 59 + ($dimension == null ? 43 : $dimension.hashCode());
        String $worldName = this.getWorldName();
        result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
        long $seed = this.getSeed();
        result = result * 59 + (int)($seed >>> 32 ^ $seed);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getMaxPlayers();
        String $levelType = this.getLevelType();
        result = result * 59 + ($levelType == null ? 43 : $levelType.hashCode());
        result = result * 59 + this.getViewDistance();
        result = result * 59 + (this.isReducedDebugInfo() ? 79 : 97);
        result = result * 59 + (this.isNormalRespawn() ? 79 : 97);
        result = result * 59 + (this.isDebug() ? 79 : 97);
        result = result * 59 + (this.isFlat() ? 79 : 97);
        return result;
    }
}

